/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.timeout;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TimerService;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.context.request.event.timeout.ApplicationScopedObserver;
import org.jboss.cdi.tck.tests.context.request.event.timeout.RequestScopedObserver;

@Stateless
public class TimeoutService {
    @Resource
    private TimerService timerService;
    @Inject
    private RequestScopedObserver observer;
    @Inject
    private ApplicationScopedObserver appObserver;

    public void start(SynchronousQueue<Boolean> queue) {
        TimerConfig config = new TimerConfig(queue, false);
        this.timerService.createSingleActionTimer(100L, config);
    }

    @Timeout
    public void onTimeout(Timer timer) {
        if (timer.getInfo() instanceof SynchronousQueue) {
            this.appObserver.reset();
            SynchronousQueue queue = (SynchronousQueue)timer.getInfo();
            try {
                queue.offer(this.observer.isInitializedObserved(), 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

