/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Apple;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Chef;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Code;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Egg;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.GreatGrannySmithAppleTree;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Guru;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Meal;
import org.jboss.cdi.tck.tests.implementation.disposal.method.definition.inheritance.Sumavanka;
import org.jboss.cdi.tck.util.DependentInstance;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class DisposerMethodInheritanceTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DisposerMethodInheritanceTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="db"), @SpecAssertion(section="member_level_inheritance", id="dh")})
    public void testManagedBeanDisposerMethodNotInherited() {
        DependentInstance<Apple> appleInstance = new DependentInstance<Apple>(this.getCurrentManager(), Apple.class, new Annotation[0]);
        Apple apple = appleInstance.get();
        Assert.assertEquals(apple.getTree().getClass(), GreatGrannySmithAppleTree.class);
        appleInstance.destroy();
        Assert.assertEquals((int)Apple.disposedBy.size(), (int)0);
        DependentInstance<Meal> mealInstance = new DependentInstance<Meal>(this.getCurrentManager(), Meal.class, new Annotation[0]);
        Meal meal = mealInstance.get();
        Assert.assertEquals(meal.getCook().getClass(), Chef.class);
        mealInstance.destroy();
        Assert.assertEquals((int)Meal.disposedBy.size(), (int)0);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="de"), @SpecAssertion(section="member_level_inheritance", id="dk")})
    public void testSessionBeanDisposerMethodNotInherited() {
        DependentInstance<Egg> eggInstance = new DependentInstance<Egg>(this.getCurrentManager(), Egg.class, new Annotation[0]);
        Egg egg = eggInstance.get();
        Assert.assertEquals(egg.getChicken().getOriginClass(), Sumavanka.class);
        eggInstance.destroy();
        Assert.assertEquals((int)Egg.disposedBy.size(), (int)0);
        DependentInstance<Code> codeInstance = new DependentInstance<Code>(this.getCurrentManager(), Code.class, new Annotation[0]);
        Code code = codeInstance.get();
        Assert.assertEquals(code.getProgrammer().getOriginClass(), Guru.class);
        codeInstance.destroy();
        Assert.assertEquals((int)Code.disposedBy.size(), (int)0);
    }
}

