/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.enterprise.newBean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.literals.DefaultLiteral;
import org.jboss.cdi.tck.literals.NewLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Dragon;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.DragonProducer;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Fireball;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Hat;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.InitializerSimpleBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.InitializerSimpleBeanLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Lion;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.LionLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Monkey;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.MonkeyLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.NewEnterpriseBeanICTest;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.NewSessionBeanConsumer;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Order;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.OrderInterceptor;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.OrderLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Spell;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Staff;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.TameLiteral;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Tiger;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.Wizard;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.WrappedEnterpriseBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.newBean.WrappedEnterpriseBeanLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="1.1 Final Release")
public class NewEnterpriseBeanTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(NewEnterpriseBeanTest.class)).withExcludedClasses(Tiger.class.getName(), Spell.class.getName(), Staff.class.getName(), Dragon.class.getName(), NewEnterpriseBeanICTest.class.getName(), Hat.class.getName(), Fireball.class.getName())).withLibrary(Tiger.class, Spell.class, Staff.class, Dragon.class, Hat.class, Fireball.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).createInterceptors().clazz(new String[]{OrderInterceptor.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertion(section="new", id="p")
    public void testNewBeanIsDependentScoped() {
        Set<Bean<WrappedEnterpriseBeanLocal>> beans = this.getBeans(WrappedEnterpriseBeanLocal.class, new Annotation[]{new NewLiteral(WrappedEnterpriseBean.class)});
        assert (beans.size() == 1);
        Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean = beans.iterator().next();
        assert (Dependent.class.equals((Object)newEnterpriseBean.getScope()));
    }

    @Test
    @SpecAssertion(section="new", id="r")
    public void testNewBeanHasOnlyOneQualifier() {
        Set<Bean<WrappedEnterpriseBeanLocal>> beans = this.getBeans(WrappedEnterpriseBeanLocal.class, new Annotation[]{new NewLiteral(WrappedEnterpriseBean.class)});
        assert (beans.size() == 1);
        Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean = beans.iterator().next();
        assert (newEnterpriseBean.getQualifiers().size() == 1);
        assert (((Annotation)newEnterpriseBean.getQualifiers().iterator().next()).annotationType().equals(New.class));
    }

    @Test
    @SpecAssertion(section="new", id="s")
    public void testNewBeanHasNoBeanELName() {
        Set<Bean<WrappedEnterpriseBeanLocal>> beans = this.getBeans(WrappedEnterpriseBeanLocal.class, new Annotation[]{new NewLiteral(WrappedEnterpriseBean.class)});
        assert (beans.size() == 1);
        Bean<WrappedEnterpriseBeanLocal> newEnterpriseBean = beans.iterator().next();
        assert (newEnterpriseBean.getName() == null);
    }

    @Test
    @SpecAssertion(section="new", id="t")
    public void testNewBeanHasNoStereotypes() {
        Bean<MonkeyLocal> monkeyBean = this.getBeans(MonkeyLocal.class, new Annotation[0]).iterator().next();
        Bean<MonkeyLocal> newMonkeyBean = this.getBeans(MonkeyLocal.class, new Annotation[]{new NewLiteral(Monkey.class)}).iterator().next();
        assert (monkeyBean.getScope().equals(RequestScoped.class));
        assert (newMonkeyBean.getScope().equals(Dependent.class));
        assert (monkeyBean.getName().equals("monkey"));
        assert (newMonkeyBean.getName() == null);
    }

    @Test
    @SpecAssertion(section="new", id="u")
    public void testNewBeanHasNoObservers() {
        assert (this.getCurrentManager().resolveObserverMethods((Object)"event", new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="new", id="j"), @SpecAssertion(section="new", id="k")})
    public void testForEachEnterpriseBeanANewBeanExists() {
        Bean<OrderLocal> orderBean = this.getBeans(OrderLocal.class, new Annotation[0]).iterator().next();
        Set<Bean<OrderLocal>> newOrderBeans = this.getBeans(OrderLocal.class, new Annotation[]{new NewLiteral(Order.class)});
        assert (newOrderBeans.size() == 1);
        Bean<OrderLocal> newOrderBean = newOrderBeans.iterator().next();
        assert (orderBean.getQualifiers().size() == 2);
        assert (orderBean.getQualifiers().contains((Object)new DefaultLiteral()));
        assert (orderBean.getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (orderBean.getTypes().equals(newOrderBean.getTypes()));
        assert (orderBean.getBeanClass().equals(newOrderBean.getBeanClass()));
        assert (newOrderBean.getQualifiers().size() == 1);
        assert (((Annotation)newOrderBean.getQualifiers().iterator().next()).annotationType().equals(New.class));
        Set<Bean<LionLocal>> lionBeans = this.getBeans(LionLocal.class, new Annotation[]{TameLiteral.INSTANCE});
        Set<Bean<LionLocal>> newLionBeans = this.getBeans(LionLocal.class, new Annotation[]{new NewLiteral(Lion.class)});
        assert (lionBeans.size() == 1);
        assert (newLionBeans.size() == 1);
        Bean<LionLocal> lionBean = lionBeans.iterator().next();
        Bean<LionLocal> newLionBean = newLionBeans.iterator().next();
        assert (lionBean.getQualifiers().size() == 2);
        assert (lionBean.getQualifiers().contains((Object)TameLiteral.INSTANCE));
        assert (lionBean.getQualifiers().contains(AnyLiteral.INSTANCE));
        assert (newLionBean.getQualifiers().size() == 1);
        assert (((Annotation)newLionBean.getQualifiers().iterator().next()).annotationType().equals(New.class));
        assert (lionBean.getTypes().equals(newLionBean.getTypes()));
        assert (lionBean.getBeanClass().equals(newLionBean.getBeanClass()));
    }

    @Test
    @SpecAssertion(section="new", id="n")
    public void testNewBeanHasSameInjectedFields() {
        Bean<InitializerSimpleBeanLocal> simpleBean = this.getBeans(InitializerSimpleBeanLocal.class, new Annotation[0]).iterator().next();
        Bean<InitializerSimpleBeanLocal> newSimpleBean = this.getBeans(InitializerSimpleBeanLocal.class, new Annotation[]{new NewLiteral(InitializerSimpleBean.class)}).iterator().next();
        assert (!newSimpleBean.getInjectionPoints().isEmpty());
        assert (simpleBean.getInjectionPoints().equals(newSimpleBean.getInjectionPoints()));
    }

    @Test
    @SpecAssertion(section="new", id="o")
    public void testNewBeanHasTheSameInterceptorBindings() {
        Assert.assertTrue((boolean)this.getContextualReference(NewSessionBeanConsumer.class, new Annotation[0]).getOrder().ping());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="new", id="yb")})
    public void testNewBeanCreatedForFieldInjectionPoint(Wizard wizard) {
        Bean<Tiger> bean = this.getUniqueBean(Tiger.class, new Annotation[]{NewLiteral.INSTANCE});
        this.checkNewQualifiedBean(bean, new Type[]{Object.class, Tiger.class});
        Assert.assertTrue((boolean)wizard.getTiger().ping());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="new", id="yd")})
    public void testNewBeanCreatedForInitializerInjectionPoint(Wizard wizard) {
        Bean<Staff> bean = this.getUniqueBean(Staff.class, new Annotation[]{NewLiteral.INSTANCE});
        this.checkNewQualifiedBean(bean, new Type[]{Object.class, Staff.class});
        Assert.assertTrue((boolean)wizard.getStaff().ping());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="new", id="yf")})
    public void testNewBeanCreatedForConstructorInjectionPoint(Wizard wizard) {
        Bean<Spell> bean = this.getUniqueBean(Spell.class, new Annotation[]{NewLiteral.INSTANCE});
        this.checkNewQualifiedBean(bean, new Type[]{Object.class, Spell.class});
        Assert.assertTrue((boolean)wizard.getSpell().ping());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="new", id="yh")})
    public void testNewBeanCreatedForProducerMethod(Wizard wizard) {
        Bean<Dragon> bean = this.getUniqueBean(Dragon.class, new Annotation[]{NewLiteral.INSTANCE});
        this.checkNewQualifiedBean(bean, new Type[]{Object.class, Dragon.class});
        Assert.assertTrue((boolean)wizard.getDragon().ping());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="new", id="yj")})
    public void testNewBeanCreatedForObserverMethod(Wizard wizard) {
        Bean<Hat> bean = this.getUniqueBean(Hat.class, new Annotation[]{NewLiteral.INSTANCE});
        this.checkNewQualifiedBean(bean, new Type[]{Object.class, Hat.class});
        this.getCurrentManager().fireEvent((Object)new Wizard(), new Annotation[0]);
        Assert.assertTrue((boolean)wizard.getHat().ping());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="new", id="yl")})
    public void testNewBeanCreatedForDisposerMethod(DragonProducer producer) {
        Bean<Fireball> bean = this.getUniqueBean(Fireball.class, new Annotation[]{NewLiteral.INSTANCE});
        this.checkNewQualifiedBean(bean, new Type[]{Object.class, Fireball.class});
        Bean<Dragon> dragonBean = this.getUniqueBean(Dragon.class, new Annotation[]{TameLiteral.INSTANCE});
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(dragonBean);
        Dragon dragon = (Dragon)dragonBean.create(ctx);
        dragonBean.destroy((Object)dragon, ctx);
        Assert.assertTrue((boolean)producer.isDragonDestroyed());
    }

    private <T> void checkNewQualifiedBean(Bean<T> bean, Type ... requiredTypes) {
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), requiredTypes));
        Assert.assertEquals((Object)bean.getScope(), Dependent.class);
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)bean.getQualifiers(), new Annotation[]{new NewLiteral(bean.getBeanClass())}));
        Assert.assertNull((Object)bean.getName());
        Assert.assertTrue((bean.getStereotypes() == null || bean.getStereotypes().isEmpty() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)bean.isAlternative());
    }
}

