/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.enterprise.definition;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.ApeLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.Dog;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.DogLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.ExplicitConstructor;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.GiraffeLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.Labrador;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.Laika;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.LionLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.MonkeyLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.NoParamConstructorSessionBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.Pitbull;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.PitbullLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.PolarBearLocal;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.Retriever;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.SimpleBean;
import org.jboss.cdi.tck.tests.implementation.enterprise.definition.Tame;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="1.1 Final Release")
public class EnterpriseBeanDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseBeanDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="session_beans", id="b")
    public void testStatelessMustBeDependentScoped() {
        assert (this.getBeans(GiraffeLocal.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(GiraffeLocal.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_bean_constructor", id="ab"), @SpecAssertion(section="instantiation", id="ab")})
    public void testConstructorAnnotatedInjectCalled() {
        ExplicitConstructor bean = this.getContextualReference(ExplicitConstructor.class, new Annotation[0]);
        assert (bean.getConstructorCalls() == 1);
        assert (bean.getInjectedSimpleBean() instanceof SimpleBean);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="instantiation", id="bb")
    public void testConstructorWithNoParamsUsed(NoParamConstructorSessionBean noParamConstructorSessionBean) {
        noParamConstructorSessionBean.ping();
        Assert.assertTrue((boolean)NoParamConstructorSessionBean.constructedCorrectly);
    }

    @Test
    @SpecAssertion(section="session_beans", id="c")
    public void testSingletonWithDependentScopeOK() {
        assert (this.getBeans(Labrador.class, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertion(section="session_beans", id="c")
    public void testSingletonWithApplicationScopeOK() {
        assert (this.getBeans(Laika.class, new Annotation[0]).size() == 1);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="session_bean_types", id="aa"), @SpecAssertion(section="declaring_session_bean", id="c")})
    public void testBeanTypesAreLocalInterfacesWithoutWildcardTypesOrTypeVariablesWithSuperInterfaces() {
        Bean<DogLocal> dogBean = this.getBeans(DogLocal.class, new Annotation[0]).iterator().next();
        assert (dogBean.getTypes().contains(DogLocal.class));
        assert (dogBean.getTypes().contains(PitbullLocal.class));
        assert (!dogBean.getTypes().contains(Pitbull.class));
    }

    @Test
    @SpecAssertion(section="session_bean_types", id="ba")
    public void testEnterpriseBeanClassLocalView() {
        Bean<Retriever> dogBean = this.getUniqueBean(Retriever.class, new Annotation[0]);
        assert (dogBean.getTypes().contains(Retriever.class));
        assert (dogBean.getTypes().contains(Dog.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="session_bean_types", id="c"), @SpecAssertion(section="declaring_session_bean", id="aa"), @SpecAssertion(section="bean_types", id="l")})
    public void testObjectIsInAPITypes() {
        assert (this.getBeans(GiraffeLocal.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(GiraffeLocal.class, new Annotation[0]).iterator().next().getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_session_bean", id="ba"), @SpecAssertion(section="session_beans", id="e")})
    public void testBeanWithScopeAnnotation() {
        Bean<LionLocal> lionBean = this.getBeans(LionLocal.class, new Annotation[0]).iterator().next();
        assert (lionBean.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="declaring_session_bean", id="bb")
    public void testBeanWithNamedAnnotation() {
        Bean<MonkeyLocal> monkeyBean = this.getBeans(MonkeyLocal.class, new Annotation[0]).iterator().next();
        assert (monkeyBean.getName().equals("Monkey"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_session_bean", id="bd"), @SpecAssertion(section="session_bean_name", id="a")})
    public void testBeanWithStereotype() {
        Bean<PolarBearLocal> polarBearBean = this.getBeans(PolarBearLocal.class, new Annotation[0]).iterator().next();
        assert (polarBearBean.getScope().equals(RequestScoped.class));
        assert (polarBearBean.getName().equals("polarBear"));
    }

    @Test
    @SpecAssertion(section="declaring_session_bean", id="be")
    public void testBeanWithQualifiers() {
        AnnotationLiteral<Tame> tame = new AnnotationLiteral<Tame>(){};
        Bean<ApeLocal> apeBean = this.getBeans(ApeLocal.class, new Annotation[]{tame}).iterator().next();
        assert (apeBean.getQualifiers().contains(tame));
    }

    @Test
    @SpecAssertion(section="session_bean_name", id="a")
    public void testDefaultName() {
        assert (this.getBeans(PitbullLocal.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(PitbullLocal.class, new Annotation[0]).iterator().next().getName().equals("pitbull"));
    }
}

