/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.resolve.typeWithParameters;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.AbstractObserver;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Bar;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Baz;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Box;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Dog;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.DogObserver;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Duck;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Foo;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.FooObserver;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.Qux;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.RawTypeObserver;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.TypeVariableObserver;
import org.jboss.cdi.tck.tests.event.resolve.typeWithParameters.WildcardObserver;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class CheckTypeParametersWhenResolvingObserversTest
extends AbstractTest {
    @Inject
    Event<Box<Integer, String, Random>> event;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(CheckTypeParametersWhenResolvingObserversTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_assignability", id="b"), @SpecAssertion(section="bm_observer_method_resolution", id="a")})
    public void testResolvingChecksTypeParameters() {
        this.verifyObserver(new StringList(), 1, StringListObserver.class);
        this.verifyObserver(new IntegerList(), 1, IntegerListObserver.class);
        this.verifyObserver(new CharacterList(), 0, new Class[0]);
    }

    @Test
    @SpecAssertion(section="observers_assignability", id="b")
    public void testParameterizedEventTypeAssignableToRawType() {
        Box box = new Box();
        this.event.fire(box);
        Assert.assertTrue((boolean)RawTypeObserver.OBSERVED);
        this.verifyObserver(new RawTypeObserver.BoxWithDifferentTypeParameters(), 1, RawTypeObserver.class);
        this.verifyObserver(new RawTypeObserver.BoxWithObjectTypeParameters(), 1, RawTypeObserver.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_assignability", id="c"), @SpecAssertion(section="observer_methods", id="ab")})
    public void testObservedEventTypeParameterIsActualType() {
        ActionSequence.reset();
        Foo.FooString fooString = new Foo.FooString();
        this.verifyObserver(fooString, 1, FooObserver.class);
        this.getCurrentManager().fireEvent((Object)fooString, new Annotation[0]);
        this.verifyEvent("fooString", 1, AbstractObserver.buildActionId(FooObserver.class, fooString));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_assignability", id="d")})
    public void testObservedEventTypeParameterIsActualTypeNested() {
        ActionSequence.reset();
        Foo.FooStringList fooStringList = new Foo.FooStringList();
        this.verifyObserver(fooStringList, 1, FooObserver.class);
        this.getCurrentManager().fireEvent((Object)fooStringList, new Annotation[0]);
        this.verifyEvent("fooStringList", 1, AbstractObserver.buildActionId(FooObserver.class, fooStringList));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observers_assignability", id="e")})
    public void testObservedEventTypeParameterIsWildcard() {
        ActionSequence.reset();
        Qux.QuxString quxString = new Qux.QuxString();
        Qux.QuxStringList quxStringList = new Qux.QuxStringList();
        Qux.QuxNumber quxNumber = new Qux.QuxNumber();
        this.verifyObserver(quxString, 1, WildcardObserver.class);
        this.verifyObserver(quxNumber, 2, WildcardObserver.class);
        this.verifyObserver(quxStringList, 2, WildcardObserver.class);
        this.getCurrentManager().fireEvent((Object)quxString, new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)quxStringList, new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)quxNumber, new Annotation[0]);
        this.verifyEvent("quxWildcard", 3, AbstractObserver.buildActionId(WildcardObserver.class, quxString), AbstractObserver.buildActionId(WildcardObserver.class, quxStringList), AbstractObserver.buildActionId(WildcardObserver.class, quxNumber));
        this.verifyEvent("quxWildcardLower", 1, AbstractObserver.buildActionId(WildcardObserver.class, quxNumber));
        this.verifyEvent("quxWildcardUpper", 1, AbstractObserver.buildActionId(WildcardObserver.class, quxStringList));
    }

    @Test
    @SpecAssertion(section="observers_assignability", id="f")
    public void testObservedEventTypeParameterIsTypeVariable() {
        ActionSequence.reset();
        Duck.DuckString duckString = new Duck.DuckString();
        Duck.DuckInteger duckInteger = new Duck.DuckInteger();
        this.verifyObserver(duckString, 1, TypeVariableObserver.class);
        this.verifyObserver(duckInteger, 2, TypeVariableObserver.class);
        this.getCurrentManager().fireEvent((Object)duckString, new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)duckInteger, new Annotation[0]);
        this.verifyEvent("duckTypeVariable", 2, AbstractObserver.buildActionId(TypeVariableObserver.class, duckString), AbstractObserver.buildActionId(TypeVariableObserver.class, duckInteger));
        this.verifyEvent("duckWildcardUpper", 1, AbstractObserver.buildActionId(TypeVariableObserver.class, duckInteger));
    }

    @Test
    @SpecAssertion(section="observers_assignability", id="a")
    public void testEventTypeAssignableToATypeVariable() {
        ActionSequence.reset();
        Bar bar = new Bar();
        Baz baz = new Baz();
        this.verifyObserver(bar, 1, TypeVariableObserver.class);
        this.verifyObserver(baz, 1, TypeVariableObserver.class);
        this.getCurrentManager().fireEvent((Object)new Bar(), new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)new Baz(), new Annotation[0]);
        this.getCurrentManager().fireEvent((Object)new StringList(), new Annotation[0]);
        this.verifyEvent("barTypeVariable", 2, AbstractObserver.buildActionId(TypeVariableObserver.class, bar), AbstractObserver.buildActionId(TypeVariableObserver.class, baz));
    }

    @Test
    public void testEventTypeResolution() {
        int expectedMatches = 5;
        Dog.DogStringNumber dogStringNumber = new Dog.DogStringNumber();
        this.verifyObserver(dogStringNumber, expectedMatches, DogObserver.class);
        this.getCurrentManager().fireEvent((Object)dogStringNumber, new Annotation[0]);
        this.verifyEvent("dog", expectedMatches, new String[0]);
    }

    private void verifyObserver(Object event, int expectedNumberOfObservers, Class<?> ... expectedObserverTypes) {
        if (expectedNumberOfObservers < expectedObserverTypes.length) {
            throw new IllegalArgumentException("Invalid expected arguments");
        }
        Set observers = this.getCurrentManager().resolveObserverMethods(event, new Annotation[0]);
        Assert.assertEquals((int)observers.size(), (int)expectedNumberOfObservers);
        List<Class<?>> observerTypes = Arrays.asList(expectedObserverTypes);
        for (ObserverMethod observer : observers) {
            Assert.assertTrue((boolean)observerTypes.contains(observer.getBeanClass()));
        }
    }

    private void verifyEvent(String sequenceName, int expectedSequenceSize, String ... actions) {
        List<String> sequenceData = ActionSequence.getSequenceData(sequenceName);
        Assert.assertNotNull(sequenceData);
        Assert.assertEquals((int)sequenceData.size(), (int)expectedSequenceSize);
        for (String action : actions) {
            Assert.assertTrue((boolean)sequenceData.contains(action));
        }
    }

    public static class IntegerListObserver {
        public boolean wasNotified = false;

        public void observer(@Observes ArrayList<Integer> event) {
            this.wasNotified = true;
        }
    }

    public static class StringListObserver {
        public boolean wasNotified = false;

        public void observer(@Observes ArrayList<String> event) {
            this.wasNotified = true;
        }
    }

    public static class IntegerList
    extends ArrayList<Integer> {
        private static final long serialVersionUID = 1L;
    }

    public static class StringList
    extends ArrayList<String> {
        private static final long serialVersionUID = 1L;
    }

    public static class CharacterList
    extends ArrayList<Character> {
        private static final long serialVersionUID = 1L;
    }
}

