/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.dependent.ejb;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.dependent.ejb.Farm;
import org.jboss.cdi.tck.tests.context.dependent.ejb.FarmLocal;
import org.jboss.cdi.tck.tests.context.dependent.ejb.Horse;
import org.jboss.cdi.tck.tests.context.dependent.ejb.House;
import org.jboss.cdi.tck.tests.context.dependent.ejb.HouseLocal;
import org.jboss.cdi.tck.tests.context.dependent.ejb.Room;
import org.jboss.cdi.tck.tests.context.dependent.ejb.Stable;
import org.jboss.cdi.tck.tests.context.dependent.ejb.Table;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class DependentContextEjbTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DependentContextEjbTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="dependent_destruction", id="aaab")
    public void testDestroyingEjbDestroysDependents() throws Exception {
        assert (this.getBeans(HouseLocal.class, new Annotation[0]).size() == 1);
        Bean<HouseLocal> bean = this.getBeans(HouseLocal.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(bean);
        HouseLocal instance = (HouseLocal)bean.create(creationalContext);
        instance.open().getTable().lay();
        Room.destroyed = false;
        Table.destroyed = false;
        House.destroyed = false;
        bean.destroy((Object)instance, creationalContext);
        assert (House.destroyed);
        assert (Room.destroyed);
        assert (Table.destroyed);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="dependent_destruction", id="aaab")
    public void testDestroyingEjbDestroysDependentSimples() throws Exception {
        assert (this.getBeans(FarmLocal.class, new Annotation[0]).size() == 1);
        Bean<FarmLocal> farmBean = this.getBeans(FarmLocal.class, new Annotation[0]).iterator().next();
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(farmBean);
        FarmLocal farm = (FarmLocal)farmBean.create(creationalContext);
        Horse.destroyed = false;
        Stable.destroyed = false;
        Farm.destroyed = false;
        farmBean.destroy((Object)farm, creationalContext);
        assert (Farm.destroyed);
        assert (Horse.destroyed);
        assert (Stable.destroyed);
    }
}

