/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.event.timeout;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.context.request.event.timeout.RequestScopedObserver;

@ApplicationScoped
public class ApplicationScopedObserver {
    @Inject
    private RequestScopedObserver observer;
    private final AtomicBoolean destroyedCalled = new AtomicBoolean();
    private SynchronousQueue<Boolean> queue = new SynchronousQueue();

    void observeRequestDestroyed(@Observes @Destroyed(value=RequestScoped.class) Object event) {
        this.destroyedCalled.set(true);
    }

    void reset() {
        this.destroyedCalled.set(false);
    }

    boolean isDestroyedCalled() {
        return this.destroyedCalled.get();
    }

    public void offerQueue() {
        this.queue.offer(this.observer.isInitializedObserved());
    }

    public Boolean pollQueue(long timeout, TimeUnit timeUnit) {
        Boolean result = new Boolean(false);
        try {
            result = this.queue.poll(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }
}

