/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Baz;
import org.jboss.cdi.tck.tests.lookup.dynamic.destroy.dependent.Qux;

public class Foo {
    private static final AtomicInteger generator = new AtomicInteger();
    private static final List<Foo> destroyedComponents = Collections.synchronizedList(new ArrayList());
    private final int id = generator.incrementAndGet();
    @Inject
    Qux qux;
    @Inject
    Baz baz;

    public void ping() {
        this.qux.ping();
        this.baz.ping();
    }

    public int getId() {
        return this.id;
    }

    public Qux getQux() {
        return this.qux;
    }

    public Baz getBaz() {
        return this.baz;
    }

    @PreDestroy
    void destroy() {
        destroyedComponents.add(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Foo)) {
            return false;
        }
        Foo other = (Foo)obj;
        return this.id == other.id;
    }

    public static List<Foo> getDestroyedComponents() {
        return destroyedComponents;
    }

    public static void reset() {
        destroyedComponents.clear();
    }
}

