/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.exclude;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.TestSystemProperty;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Beans11DescriptorImpl;
import org.jboss.cdi.tck.shrinkwrap.descriptors.ClassActivator;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Exclude;
import org.jboss.cdi.tck.shrinkwrap.descriptors.SystemPropertyActivator;
import org.jboss.cdi.tck.tests.deployment.exclude.Alpha;
import org.jboss.cdi.tck.tests.deployment.exclude.Bravo;
import org.jboss.cdi.tck.tests.deployment.exclude.Charlie;
import org.jboss.cdi.tck.tests.deployment.exclude.Delta;
import org.jboss.cdi.tck.tests.deployment.exclude.Echo;
import org.jboss.cdi.tck.tests.deployment.exclude.Foxtrot;
import org.jboss.cdi.tck.tests.deployment.exclude.Golf;
import org.jboss.cdi.tck.tests.deployment.exclude.Stubble;
import org.jboss.cdi.tck.tests.deployment.exclude.VerifyingExtension;
import org.jboss.cdi.tck.tests.deployment.exclude.food.Meat;
import org.jboss.cdi.tck.tests.deployment.exclude.haircut.Chonmage;
import org.jboss.cdi.tck.tests.deployment.exclude.mustache.Mustache;
import org.jboss.cdi.tck.tests.deployment.exclude.mustache.beard.Beard;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ExcludeFiltersTest
extends AbstractTest {
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExcludeFiltersTest.class)).withPackage(Mustache.class.getPackage())).withPackage(Beard.class.getPackage())).withPackage(Chonmage.class.getPackage())).withPackage(Meat.class.getPackage())).withBeansXml(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ALL).excludes(Exclude.newExclude(Chonmage.class.getPackage().getName() + ".*"), Exclude.newExclude(Mustache.class.getPackage().getName() + ".**"), Exclude.newExclude(Meat.class.getPackage().getName() + ".*").activators(ClassActivator.newClassAvailableActivator("com.some.unreal.class.Name")), Exclude.newExclude(Meat.class.getPackage().getName() + ".*").activators(ClassActivator.newClassNotAvailableActivator(ExcludeFiltersTest.class.getName())), Exclude.newExclude(Stubble.class.getName()), Exclude.newExclude(Alpha.class.getName()).activators(ClassActivator.newClassAvailableActivator(Stubble.class.getName())), Exclude.newExclude(Foxtrot.class.getName()).activators(ClassActivator.newClassAvailableActivator("com.some.unreal.class.Name")), Exclude.newExclude(Bravo.class.getName()).activators(ClassActivator.newClassNotAvailableActivator("com.some.unreal.class.Name")), Exclude.newExclude(Echo.class.getName()).activators(ClassActivator.newClassNotAvailableActivator(ExcludeFiltersTest.class.getName())), Exclude.newExclude(Charlie.class.getName()).activators(SystemPropertyActivator.newSystemPropertyActivator(TestSystemProperty.EXCLUDE_DUMMY.getKey())), Exclude.newExclude(Delta.class.getName()).activators(SystemPropertyActivator.newSystemPropertyActivator(TestSystemProperty.EXCLUDE_DUMMY.getKey()).setValue(TestSystemProperty.EXCLUDE_DUMMY.getValue()))))).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_discovery", id="pa"), @SpecAssertion(section="bean_discovery", id="qa")})
    public void testTypeFcqnMatchesExcludeFilterName() {
        this.assertTypeIsExcluded(Stubble.class);
        this.assertTypeIsNotExcluded(Golf.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_discovery", id="pa"), @SpecAssertion(section="bean_discovery", id="qb"), @SpecAssertion(section="bean_discovery", id="qc")})
    public void testTypePackageMatchesExcludeFilterName() {
        this.assertTypeIsExcluded(Mustache.class);
        this.assertTypeIsExcluded(Beard.class);
        this.assertTypeIsExcluded(Chonmage.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bean_discovery", id="pb"), @SpecAssertion(section="bean_discovery", id="pc")})
    public void testExcludeClassActivators() {
        this.assertTypeIsExcluded(Alpha.class);
        this.assertTypeIsNotExcluded(Foxtrot.class);
        this.assertTypeIsExcluded(Bravo.class);
        this.assertTypeIsNotExcluded(Echo.class);
        this.assertTypeIsNotExcluded(Meat.class);
    }

    @Test(groups={"integration", "systemProperties"})
    @SpecAssertions(value={@SpecAssertion(section="bean_discovery", id="pd"), @SpecAssertion(section="bean_discovery", id="pe")})
    public void testExcludeSystemPropertyActivator() {
        this.assertTypeIsExcluded(Charlie.class);
        this.assertTypeIsExcluded(Delta.class);
    }

    private void assertTypeIsExcluded(Class<?> type) {
        Assert.assertTrue((boolean)this.getBeans(type, new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.extension.getObservedAnnotatedTypes().contains(type));
    }

    private void assertTypeIsNotExcluded(Class<?> type) {
        Assert.assertFalse((boolean)this.getBeans(type, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(type));
    }
}

