/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.ejb.EjbJarDescriptorBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.MessageDrivenMissile;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.SimpleMessageProducer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EjbJarDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class MessageDrivenBeanInterceptorInvocationTest
extends AbstractTest {
    @Inject
    SimpleMessageProducer producer;

    @Deployment
    public static WebArchive createTestArchive() {
        EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptorBuilder().messageDrivenBeans(EjbJarDescriptorBuilder.MessageDriven.newMessageDriven("TestQueue", MessageDrivenMissile.class.getName()).addActivationConfigProperty("acknowledgeMode", "Auto-acknowledge").addActivationConfigProperty("destinationType", "javax.jms.Queue").addActivationConfigProperty("destinationLookup", ConfigurationFactory.get().getTestJmsQueue())).build();
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MessageDrivenBeanInterceptorInvocationTest.class)).withEjbJarXml(ejbJarDescriptor)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{MissileInterceptor.class.getName()}).up())).build();
    }

    @Test(groups={"javaee-full", "jms"})
    @SpecAssertions(value={@SpecAssertion(section="biz_method", id="la")})
    public void testMessageDrivenBeanMethodIntercepted() throws Exception {
        MissileInterceptor.reset();
        this.producer.sendQueueMessage();
        Assert.assertEquals((String)MessageDrivenMissile.class.getName(), (String)MessageDrivenMissile.MESSAGES.poll(5L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)MissileInterceptor.METHOD_INTERCEPTED.get());
        Assert.assertTrue((boolean)MissileInterceptor.lifecycleCallbackIntercepted);
    }
}

