/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.dependency.builtin;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Boss;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Hammer;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Inspector;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.InspectorAssistant;
import org.jboss.cdi.tck.tests.context.passivating.dependency.builtin.Worker;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class BuiltinBeanPassivationDependencyTest
extends AbstractTest {
    @Inject
    Worker worker;
    @Inject
    Boss boss;
    @Inject
    InspectorAssistant inspectorAssist;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinBeanPassivationDependencyTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="ea")})
    public void testInstance() throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)this.worker);
        Assert.assertNotNull(this.worker.getInstance());
        Hammer hammer = (Hammer)this.worker.getInstance().get();
        Assert.assertNotNull((Object)hammer);
        String workerId = this.worker.getId();
        String hammerId = hammer.getId();
        byte[] serializedWorker = this.passivate(this.worker);
        Worker workerCopy = (Worker)this.activate(serializedWorker);
        Assert.assertNotNull((Object)workerCopy);
        Assert.assertNotNull(workerCopy.getInstance());
        Assert.assertEquals((String)workerCopy.getId(), (String)workerId);
        Assert.assertEquals((String)((Hammer)workerCopy.getInstance().get()).getId(), (String)hammerId);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="ed")})
    public void testBeanManager() throws IOException, ClassNotFoundException {
        Assert.assertNotNull((Object)this.boss);
        Assert.assertNotNull((Object)this.boss.getBeanManager());
        String bossId = this.boss.getId();
        byte[] serializedBoss = this.passivate(this.boss);
        Boss bossCopy = (Boss)this.activate(serializedBoss);
        Assert.assertNotNull((Object)bossCopy);
        Assert.assertNotNull((Object)bossCopy.getBeanManager());
        Assert.assertEquals((String)bossCopy.getId(), (String)bossId);
        Assert.assertEquals((int)bossCopy.getBeanManager().getBeans(Boss.class, new Annotation[0]).size(), (int)1);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency", id="ec")})
    public void testInjectionPoint() throws IOException, ClassNotFoundException {
        Inspector inspector = this.inspectorAssist.getInspector();
        Assert.assertNotNull((Object)inspector);
        Assert.assertNotNull((Object)inspector.getInjectionPoint());
        String inspectorId = inspector.getId();
        byte[] serializedInspector = this.passivate(inspector);
        Inspector inspectorCopy = (Inspector)this.activate(serializedInspector);
        Assert.assertNotNull((Object)inspectorCopy);
        Assert.assertNotNull((Object)inspectorCopy.getInjectionPoint());
        Assert.assertEquals((String)inspectorCopy.getId(), (String)inspectorId);
        Assert.assertEquals((Object)inspectorCopy.getInjectionPoint(), (Object)inspector.getInjectionPoint());
        Assert.assertEquals((Object)inspectorCopy.getInjectionPoint().getType(), (Object)inspector.getInjectionPoint().getType());
        Assert.assertEquals((Set)inspectorCopy.getInjectionPoint().getQualifiers(), (Set)inspector.getInjectionPoint().getQualifiers());
        Assert.assertEquals((Object)inspectorCopy.getInjectionPoint().getBean(), (Object)inspector.getInjectionPoint().getBean());
        Assert.assertEquals((Object)inspectorCopy.getInjectionPoint().getMember(), (Object)inspector.getInjectionPoint().getMember());
        Assert.assertEquals((Object)inspectorCopy.getInjectionPoint().getAnnotated(), (Object)inspector.getInjectionPoint().getAnnotated());
        Assert.assertEquals((boolean)inspectorCopy.getInjectionPoint().isDelegate(), (boolean)inspector.getInjectionPoint().isDelegate());
        Assert.assertEquals((boolean)inspectorCopy.getInjectionPoint().isTransient(), (boolean)inspector.getInjectionPoint().isTransient());
    }
}

