/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.ws;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.request.ws.Translator;
import org.jboss.cdi.tck.tests.context.request.ws.TranslatorService;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class RequestContextTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextTest.class)).withExcludedClass(TranslatorService.class.getName())).withWebXml((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createServlet().servletName("Translator").servletClass("org.jboss.cdi.tck.tests.context.request.ws.TranslatorEndpoint").loadOnStartup(Integer.valueOf(1)).up()).createServletMapping().servletName("Translator").urlPattern(new String[]{"/translator"}).up())).build();
    }

    @Test(groups={"javaee-full", "jaxws"})
    @SpecAssertions(value={@SpecAssertion(section="request_context", id="c"), @SpecAssertion(section="request_context", id="d"), @SpecAssertion(section="application_context", id="b")})
    public void testRequestScopeActiveDuringWebServiceInvocation() throws Exception {
        URL wsdlLocation = new URL(this.contextPath.toExternalForm() + "translator?wsdl");
        TranslatorService endpointService = new TranslatorService(wsdlLocation);
        Translator translator = endpointService.getTranslatorEndpointPort();
        String id01 = translator.translate();
        String id02 = translator.translate();
        Assert.assertNotEquals((Object)id01, (Object)id02);
        final WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage info = (TextPage)webClient.getPage(this.contextPath + "info");
        Timer timer = new Timer().setDelay(5L, TimeUnit.SECONDS).setSleepInterval(1000L).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                TextPage info = null;
                try {
                    info = (TextPage)webClient.getPage(RequestContextTest.this.contextPath + "info");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                Matcher matcher = Pattern.compile("(Foo destroyed:)(\\w+)").matcher(info.getContent());
                if (matcher.find()) {
                    String value = matcher.group(2);
                    return Integer.valueOf(value) == 2;
                }
                return false;
            }
        }).start();
        Assert.assertTrue((boolean)timer.isStopConditionsSatisfiedBeforeTimeout());
    }
}

