/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.bootstrap.unavailable.methods;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.cdi.tck.tests.extensions.beanManager.bootstrap.unavailable.methods.Foo;
import org.jboss.cdi.tck.tests.extensions.beanManager.bootstrap.unavailable.methods.Transactional;
import org.testng.Assert;

public class WrongExtension
implements Extension {
    private Bean<Foo> fooBean;
    private InjectionPoint injectionPoint;

    public void observeBeforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeProcessAnnotatedType(@Observes ProcessAnnotatedType<?> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeAfterTypeDiscovery(@Observes AfterTypeDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeProcessInjectionTarget(@Observes ProcessInjectionTarget<Foo> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeInjectionPoint(@Observes ProcessInjectionPoint<Foo, ?> event, BeanManager beanManager) {
        if (this.injectionPoint == null) {
            this.injectionPoint = event.getInjectionPoint();
        }
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observerProcessBeanAttributes(@Observes ProcessBeanAttributes<Foo> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
    }

    public void observeProcessBean(@Observes ProcessBean<Foo> event, BeanManager beanManager) {
        this.fooBean = event.getBean();
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observerProcessObserverMethod(@Observes ProcessObserverMethod<Integer, Foo> event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeABD(beanManager);
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observeAfterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager beanManager) {
        this.testUnavailableMethodsBeforeADV(beanManager);
    }

    public void observerAfterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        this.testAvailableMethods(manager);
    }

    private void testUnavailableMethodsBeforeABD(final BeanManager beanManager) {
        new Invocation(){

            @Override
            void execute() {
                beanManager.getBeans("foo");
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.getBeans(Foo.class, new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolve(null);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolveObserverMethods((Object)new Foo(), new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}});
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.resolveDecorators(new HashSet<Class>(Arrays.asList(Foo.class)), new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.validate(WrongExtension.this.injectionPoint);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.getPassivationCapableBean("foo");
            }
        }.run();
    }

    private void testUnavailableMethodsBeforeADV(final BeanManager beanManager) {
        final CreationalContext creationalContext = beanManager.createCreationalContext(this.fooBean);
        new Invocation(){

            @Override
            void execute() {
                beanManager.getReference(WrongExtension.this.fooBean, Foo.class, creationalContext);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                beanManager.getInjectableReference(beanManager.createInjectionPoint((AnnotatedField)beanManager.createAnnotatedType(Foo.class).getFields().iterator().next()), creationalContext);
            }
        }.run();
    }

    private void testAvailableMethods(BeanManager beanManager) {
        beanManager.getReference((Bean)new FooBean(), Foo.class, beanManager.createCreationalContext(null));
        beanManager.getBeans("foo");
        beanManager.getBeans(Foo.class, new Annotation[0]);
        beanManager.getInjectableReference(beanManager.createInjectionPoint((AnnotatedField)beanManager.createAnnotatedType(Foo.class).getFields().iterator().next()), beanManager.createCreationalContext(null));
        beanManager.resolve(null);
        beanManager.resolveObserverMethods((Object)new Foo(), new Annotation[0]);
        beanManager.resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<Transactional>(){}});
        beanManager.resolveDecorators(new HashSet<Class>(Arrays.asList(Foo.class)), new Annotation[0]);
        beanManager.validate(this.injectionPoint);
        beanManager.getPassivationCapableBean("foo");
    }

    private static abstract class Invocation {
        private Invocation() {
        }

        void run() {
            try {
                this.execute();
                Assert.fail((String)"Expected exception not thrown");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        abstract void execute();
    }

    @Vetoed
    private static class FooInjectionPoint
    implements InjectionPoint {
        private FooInjectionPoint() {
        }

        public boolean isTransient() {
            return false;
        }

        public boolean isDelegate() {
            return false;
        }

        public Type getType() {
            return Foo.class;
        }

        public Set<Annotation> getQualifiers() {
            return null;
        }

        public Member getMember() {
            return null;
        }

        public Bean<?> getBean() {
            return null;
        }

        public Annotated getAnnotated() {
            return null;
        }
    }

    private static class FooBean
    implements Bean<Foo> {
        private FooBean() {
        }

        public Class<?> getBeanClass() {
            return Foo.class;
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return Collections.emptySet();
        }

        public boolean isNullable() {
            return false;
        }

        public Set<Type> getTypes() {
            HashSet<Type> set = new HashSet<Type>();
            set.add((Type)((Object)Foo.class));
            return set;
        }

        public Set<Annotation> getQualifiers() {
            return Collections.emptySet();
        }

        public Class<? extends Annotation> getScope() {
            return Dependent.class;
        }

        public String getName() {
            return null;
        }

        public Set<Class<? extends Annotation>> getStereotypes() {
            return Collections.emptySet();
        }

        public boolean isAlternative() {
            return false;
        }

        public Foo create(CreationalContext<Foo> creationalContext) {
            return null;
        }

        public void destroy(Foo instance, CreationalContext<Foo> creationalContext) {
        }
    }
}

