/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.events;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSessionBean;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.events.SessionBean;
import org.jboss.cdi.tck.tests.extensions.lifecycle.events.SimpleAnnotation;
import org.jboss.cdi.tck.tests.extensions.lifecycle.events.SimpleBean;
import org.jboss.cdi.tck.tests.extensions.lifecycle.events.TestExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ContainerLifeCycleEventRuntimeInvocationTest
extends AbstractTest {
    @Inject
    TestExtension extension;
    @Inject
    BeanManager beanManager;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(ContainerLifeCycleEventRuntimeInvocationTest.class)).withClasses(TestExtension.class, SimpleAnnotation.class, SimpleBean.class, SessionBean.class)).withExtension(TestExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="before_bean_discovery", id="b")})
    public void testBeforeBeanDiscoveryEventFails() {
        final BeforeBeanDiscovery event = this.extension.getBeforeBeanDiscovery();
        final AnnotatedType type = this.beanManager.createAnnotatedType(ContainerLifeCycleEventRuntimeInvocationTest.class);
        final AnnotatedType annotation = this.beanManager.createAnnotatedType(SimpleAnnotation.class);
        new Invocation(){

            @Override
            void execute() {
                event.addAnnotatedType(type);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addAnnotatedType(type, "foo");
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addInterceptorBinding(SimpleAnnotation.class, new Annotation[0]);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addInterceptorBinding(annotation);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addQualifier(SimpleAnnotation.class);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addQualifier(annotation);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addScope(SimpleAnnotation.class, true, false);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addStereotype(SimpleAnnotation.class, new Annotation[0]);
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_type_discovery", id="j")})
    public void testAfterTypeDiscoveryEventFails() {
        final AfterTypeDiscovery event = this.extension.getAfterTypeDiscovery();
        final AnnotatedType type = this.beanManager.createAnnotatedType(ContainerLifeCycleEventRuntimeInvocationTest.class);
        new Invocation(){

            @Override
            void execute() {
                event.addAnnotatedType(type, "bar");
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAlternatives();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getDecorators();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getInterceptors();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_bean_discovery", id="h")})
    public void testAfterBeanDiscoveryEventFails() {
        final AfterBeanDiscovery event = this.extension.getAfterBeanDiscovery();
        new Invocation(){

            @Override
            void execute() {
                event.addBean((Bean)ContainerLifeCycleEventRuntimeInvocationTest.this.beanManager.getBeans(SimpleBean.class, new Annotation[0]).iterator().next());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addContext(ContainerLifeCycleEventRuntimeInvocationTest.this.beanManager.getContext(SessionScoped.class));
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addObserverMethod(ContainerLifeCycleEventRuntimeInvocationTest.this.extension.getProcessObserverMethod().getObserverMethod());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedType(ContainerLifeCycleEventRuntimeInvocationTest.class, "foo");
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedTypes(ContainerLifeCycleEventRuntimeInvocationTest.class);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="after_deployment_validation", id="e")})
    public void testAfterDeploymentValidationEventFails() {
        final AfterDeploymentValidation event = this.extension.getAfterDeploymentValidation();
        new Invocation(){

            @Override
            void execute() {
                event.addDeploymentProblem((Throwable)new NullPointerException());
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_annotated_type", id="f")})
    public void testProcessAnnotatedTypeEventFails() {
        final ProcessAnnotatedType<SimpleBean> event = this.extension.getProcessAnnotatedType();
        final AnnotatedType type = this.beanManager.createAnnotatedType(SimpleBean.class);
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedType();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.setAnnotatedType(type);
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_annotated_type", id="f")})
    public void testProcessSyntheticAnnotatedTypeEventFails() {
        final ProcessSyntheticAnnotatedType<SimpleBean> event = this.extension.getProcessSyntheticAnnotatedType();
        final AnnotatedType type = this.beanManager.createAnnotatedType(SimpleBean.class);
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedType();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getSource();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.setAnnotatedType(type);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.veto();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean", id="o")})
    public void testProcessBeanEventFails() {
        final ProcessBean<SimpleBean> event = this.extension.getProcessBean();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotated();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getBean();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean", id="o")})
    public void testProcessManagedBeanEventFails() {
        final ProcessManagedBean<SimpleBean> event = this.extension.getProcessManagedBean();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotated();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedBeanClass();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getBean();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean", id="o")})
    public void testProcessSessionBeanEventFails() {
        final ProcessSessionBean<SessionBean> event = this.extension.getProcessSessionBean();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotated();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedBeanClass();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getEjbName();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getSessionBeanType();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getBean();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean", id="o")})
    public void testProcessProducerMethodEventFails() {
        final ProcessProducerMethod<Integer, SimpleBean> event = this.extension.getProcessProducerMethod();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotated();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedProducerMethod();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedDisposedParameter();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getBean();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean", id="o")})
    public void testProcessProducerFieldEventFails() {
        final ProcessProducerField<Integer, SimpleBean> event = this.extension.getProcessProducerField();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotated();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedProducerField();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedDisposedParameter();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getBean();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_bean_attributes", id="f")})
    public void testProcessBeanAttributesEventFails() {
        final ProcessBeanAttributes<SimpleBean> event = this.extension.getProcessBeanAttributes();
        AnnotatedType type = this.beanManager.createAnnotatedType(SimpleBean.class);
        final BeanAttributes attributes = this.beanManager.createBeanAttributes(type);
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotated();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.setBeanAttributes(attributes);
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getBeanAttributes();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.veto();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_observer_method", id="dc")})
    public void testProcessObserverMethodEventFails() {
        final ProcessObserverMethod<SimpleBean, ?> event = this.extension.getProcessObserverMethod();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedMethod();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getObserverMethod();
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target", id="g")})
    public void testProcessInjectionTargetEventFails() {
        final ProcessInjectionTarget<SimpleBean> event = this.extension.getProcessInjectionTarget();
        AnnotatedType type = this.beanManager.createAnnotatedType(SimpleBean.class);
        final InjectionTarget target = this.beanManager.createInjectionTarget(type);
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedType();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getInjectionTarget();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.setInjectionTarget(target);
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_point", id="e")})
    public void testProcessInjectionPointEventFails() {
        final ProcessInjectionPoint<SimpleBean, ?> event = this.extension.getProcessInjectionPoint();
        AnnotatedType type = this.beanManager.createAnnotatedType(SimpleBean.class);
        AnnotatedField field = (AnnotatedField)type.getFields().iterator().next();
        final InjectionPoint injectionPoint = this.beanManager.createInjectionPoint(field);
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getInjectionPoint();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.setInjectionPoint(injectionPoint);
            }
        }.run();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_producer", id="i")})
    public void testProcessProducer() {
        final ProcessProducer<SimpleBean, Integer> event = this.extension.getProcessProducer();
        new Invocation(){

            @Override
            void execute() {
                event.addDefinitionError((Throwable)new NullPointerException());
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getProducer();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.getAnnotatedMember();
            }
        }.run();
        new Invocation(){

            @Override
            void execute() {
                event.setProducer((Producer)new Producer<Integer>(){

                    public Integer produce(CreationalContext<Integer> ctx) {
                        return new Integer(0);
                    }

                    public void dispose(Integer instance) {
                    }

                    public Set<InjectionPoint> getInjectionPoints() {
                        return Collections.emptySet();
                    }
                });
            }
        }.run();
    }

    private static abstract class Invocation {
        private Invocation() {
        }

        void run() {
            try {
                this.execute();
                Assert.fail((String)"Expected exception not thrown");
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        abstract void execute();
    }
}

