/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.AnyLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.Bicycle;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.BicycleExtension;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processBeanAttributes.synthetic.Vehicle;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="1.1 Final Release")
public class ProcessBeanAttributesNotFiredForSyntheticBeanTest
extends AbstractTest {
    @Inject
    BicycleExtension bicycleExtension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProcessBeanAttributesNotFiredForSyntheticBeanTest.class)).withExtension(BicycleExtension.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_beanattributes", id="a"), @SpecAssertion(section="process_bean_attributes", id="ae"), @SpecAssertion(section="process_annotated_type", id="bc")})
    public void testProcessBeanAttributesNotFired() {
        Assert.assertTrue((boolean)this.bicycleExtension.isVetoed());
        BeanAttributes<Bicycle> attributesBeforeRegistering = this.bicycleExtension.getBicycleAttributesBeforeRegistering();
        Assert.assertEquals((Object)attributesBeforeRegistering.getScope(), ApplicationScoped.class);
        Assert.assertTrue((boolean)this.typeSetMatches(attributesBeforeRegistering.getTypes(), new Type[]{Object.class, Vehicle.class, Bicycle.class}));
        Assert.assertFalse((boolean)attributesBeforeRegistering.isAlternative());
        Assert.assertNull(this.bicycleExtension.getBicycleAttributesBeforeModifying());
        Set<Bean<Bicycle>> beans = this.getBeans(Bicycle.class, new Annotation[]{AnyLiteral.INSTANCE});
        Assert.assertEquals((int)beans.size(), (int)1);
        Bean<Bicycle> bean = beans.iterator().next();
        Assert.assertEquals((Object)bean.getScope(), ApplicationScoped.class);
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Object.class, Vehicle.class, Bicycle.class}));
        Assert.assertFalse((boolean)bean.isAlternative());
    }
}

