/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.bbd;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.Alligator;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.BeforeBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.EpochScoped;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.Programmer;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.RomanEmpire;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.SkillLiteral;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.Tame;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.lib.Bar;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.lib.Boss;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.lib.Foo;
import org.jboss.cdi.tck.tests.extensions.lifecycle.bbd.lib.Pro;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class BeforeBeanDiscoveryTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeforeBeanDiscoveryTest.class)).withExtension(BeforeBeanDiscoveryObserver.class)).withLibrary(Boss.class, Foo.class, Bar.class, Pro.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="before_bean_discovery", id="a"), @SpecAssertion(section="initialization", id="b"), @SpecAssertion(section="initialization", id="c")})
    public void testBeforeBeanDiscoveryEventIsCalled() {
        Assert.assertTrue((boolean)BeforeBeanDiscoveryObserver.isObserved());
    }

    @Test
    @SpecAssertion(section="before_bean_discovery", id="ac")
    public void testAddingScopeType() {
        Assert.assertTrue((boolean)BeforeBeanDiscoveryObserver.isObserved());
        Assert.assertEquals((int)this.getBeans(RomanEmpire.class, new Annotation[0]).size(), (int)1);
        Bean<RomanEmpire> bean = this.getBeans(RomanEmpire.class, new Annotation[0]).iterator().next();
        Assert.assertTrue((boolean)bean.getScope().equals(EpochScoped.class));
    }

    @Test
    @SpecAssertion(section="before_bean_discovery", id="ab")
    public void testAddingQualifierByClass() {
        Assert.assertTrue((boolean)BeforeBeanDiscoveryObserver.isObserved());
        Assert.assertEquals((int)this.getBeans(Alligator.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Alligator.class, new Annotation[]{new AnnotationLiteral<Tame>(){}}).size(), (int)1);
        Assert.assertTrue((boolean)this.getCurrentManager().isQualifier(Tame.class));
    }

    @Test
    @SpecAssertion(section="before_bean_discovery", id="aba")
    public void testAddingQualifierByAnnotatedType() {
        Assert.assertTrue((boolean)BeforeBeanDiscoveryObserver.isObserved());
        Assert.assertEquals((int)this.beanManager.getBeans(Programmer.class, new Annotation[]{new SkillLiteral(){

            @Override
            public String language() {
                return "Java";
            }

            @Override
            public String level() {
                return "whatever";
            }
        }}).size(), (int)1);
        Assert.assertEquals((int)this.beanManager.getBeans(Programmer.class, new Annotation[]{new SkillLiteral(){

            @Override
            public String language() {
                return "C++";
            }

            @Override
            public String level() {
                return "guru";
            }
        }}).size(), (int)0);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="before_bean_discovery", id="af"), @SpecAssertion(section="type_discovery_steps", id="d")})
    public void testAddAnnotatedType() {
        this.getUniqueBean(Boss.class, new Annotation[0]);
        Assert.assertEquals((int)this.getBeans(Bar.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Bar.class, new Annotation[]{new AnnotationLiteral<Pro>(){}}).size(), (int)1);
        Assert.assertEquals((int)this.getBeans(Foo.class, new Annotation[0]).size(), (int)0);
        Assert.assertEquals((int)this.getBeans(Foo.class, new Annotation[]{new AnnotationLiteral<Pro>(){}}).size(), (int)1);
    }
}

