/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.ee.components;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.util.Arrays;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class JavaEEComponentsTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(JavaEEComponentsTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="javaee_components", id="a")})
    public void testComponentInject() throws Exception {
        this.assertComponentInstancesNotEqual("inject");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="javaee_components", id="b")})
    public void testComponentProducerMethod() throws Exception {
        this.assertComponentInstancesNotEqual("pm");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="javaee_components", id="c")})
    public void testComponentProducerField() throws Exception {
        this.assertComponentInstancesNotEqual("pf");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="javaee_components", id="d")})
    public void testComponentObserverMethod() throws Exception {
        this.assertComponentInstancesNotEqual("om");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="javaee_components", id="e")})
    public void testComponentDisposerMethod() throws Exception {
        this.assertComponentInstancesNotEqual("dm");
    }

    private void assertComponentInstancesNotEqual(String mode) throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        TextPage page = (TextPage)webClient.getPage(this.contextPath + "test?mode=" + mode);
        Object[] ids = page.getContent().split(":");
        System.out.println(Arrays.toString(ids));
        Assert.assertEquals((int)ids.length, (int)2);
        Assert.assertNotEquals((Object)ids[0], (Object)ids[1]);
    }
}

