/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.dynamic.builtin;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.AbstractAnimal;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Animal;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Cow;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Farm;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.FarmBased;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Field;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.FinalAnimal;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Predator;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Sheep;
import org.jboss.cdi.tck.tests.lookup.dynamic.builtin.Wolf;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class BuiltinInstanceTest
extends AbstractTest {
    private static final AnnotationLiteral<FarmBased> farmBasedLiteral = new AnnotationLiteral<FarmBased>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BuiltinInstanceTest.class)).build();
    }

    @Test
    @SpecAssertion(section="builtin_instance", id="d")
    public void testScopeOfBuiltinInstance() {
        Bean<Instance<Cow>> bean = this.getUniqueBean(new TypeLiteral<Instance<Cow>>(){}, new Annotation[0]);
        Assert.assertEquals((Object)bean.getScope(), Dependent.class);
    }

    @Test
    @SpecAssertion(section="builtin_instance", id="e")
    public void testNameOfBuiltinInstance() {
        Bean<Instance<Cow>> bean = this.getUniqueBean(new TypeLiteral<Instance<Cow>>(){}, new Annotation[0]);
        Assert.assertNull((Object)bean.getName());
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="builtin_instance", id="f")})
    public void testInstanceProvidedForEveryLegalBeanType(Farm farm, Instance<Predator<?>> predatorInstance) {
        Bean<Instance<Animal>> instanceBean = this.getUniqueBean(new TypeLiteral<Instance<Animal>>(){}, new Annotation[0]);
        Assert.assertEquals(this.getUniqueBean(new TypeLiteral<Instance<AbstractAnimal>>(){}, new Annotation[0]), instanceBean);
        Assert.assertEquals(this.getUniqueBean(new TypeLiteral<Instance<FinalAnimal>>(){}, new Annotation[0]), instanceBean);
        Assert.assertEquals(this.getUniqueBean(new TypeLiteral<Instance<Wolf>>(){}, new Annotation[0]), instanceBean);
        Assert.assertEquals(this.getUniqueBean(new TypeLiteral<Instance<Predator>>(){}, new Annotation[0]), instanceBean);
        Assert.assertEquals(this.getUniqueBean(new TypeLiteral<Instance<Sheep[]>>(){}, new Annotation[0]), instanceBean);
        Assert.assertEquals(this.getUniqueBean(new TypeLiteral<Instance<Integer>>(){}, new Annotation[]{farmBasedLiteral}), instanceBean);
        Assert.assertNotNull(predatorInstance);
        ((Wolf)predatorInstance.select(Wolf.class, new Annotation[0]).get()).attack((Sheep)null);
        Assert.assertNotNull(farm.getAnimal());
        Assert.assertNotNull(farm.getAbstractAnimal());
        Assert.assertNotNull(farm.getCow());
        ((Cow)farm.getCow().get()).ping();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="builtin_instance", id="g")
    public void testInstanceIsPassivationCapable(Field field) throws Exception {
        Assert.assertNotNull((Object)field);
        Object object = this.activate(this.passivate(field));
        assert (field.getInstance().get() instanceof Cow);
        assert (object instanceof Field);
        Field field2 = (Field)object;
        assert (field2.getInstance().get() instanceof Cow);
    }
}

