/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.container;

import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.container.Bar;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class BootstrapSEWithSystemPropertyTest
extends Arquillian {
    @Deployment
    public static Archive<?> deployment() {
        JavaArchive testArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(BootstrapSEWithSystemPropertyTest.class);
        JavaArchive implicitArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Bar.class);
        Properties properties = new Properties();
        properties.put("javax.enterprise.inject.scan.implicit", "true");
        return ClassPath.builder().add(new JavaArchive[]{testArchive, implicitArchive}).addSystemProperties(properties).build();
    }

    @Test
    @SpecAssertion(section="bean_archive_se", id="a")
    public void testImplicitArchiveDiscovered() {
        CDIProvider cdiProvider = CDI.getCDIProvider();
        try (CDI cdi = cdiProvider.initialize();){
            Bar bar = (Bar)cdi.select(Bar.class, new Annotation[0]).get();
            Assert.assertNotNull((Object)bar);
            bar.ping();
        }
    }
}

