/*
 * JBoss, Home of Professional Open Source
 * Copyright 2015, Red Hat, Inc., and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.jboss.cdi.tck.tests.implementation.disposal.method.definition.invocation;

import static org.jboss.cdi.tck.cdi.Sections.DISPOSER_METHOD_DISPOSED_PARAMETER;

import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;

import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec = "cdi", version = "2.0-EDR1")
public class DisposesMethodCalledOnceTest extends AbstractTest {

    @Inject
    BeanManager beanManager;

    @Deployment
    public static WebArchive getDeployment() {
        return new WebArchiveBuilder().withTestClassPackage(DisposesMethodCalledOnceTest.class).build();
    }

    @Test
    @SpecAssertion(section = DISPOSER_METHOD_DISPOSED_PARAMETER, id = "ba")
    public void testDisposerCalledOnce1() {
        ProducerBean.reset();
        beanManager.fireEvent("Hello");
        Assert.assertEquals(ProducerBean.firstDisposerCalled.get(), 1, "Disposer method called multiple times!");

    }

    @Test
    @SpecAssertion(section = DISPOSER_METHOD_DISPOSED_PARAMETER, id = "ba")
    public void testDisposerCalledOnce2() {
        ProducerBean.reset();
        beanManager.fireEvent("Hello");
        Assert.assertEquals(ProducerBean.secondDisposerCalled.get(), 1, "Disposer method called multiple times!");
    }

    @Test
    @SpecAssertion(section = DISPOSER_METHOD_DISPOSED_PARAMETER, id = "ba")
    public void testDisposerCalledOnce3() {
        ProducerBean.reset();
        beanManager.fireEvent("Hello");
        Assert.assertEquals(ProducerBean.thirdDisposerCalled.get(), 1, "Disposer method called multiple times!");
    }

    @Test
    @SpecAssertion(section = DISPOSER_METHOD_DISPOSED_PARAMETER, id = "ba")
    public void testDisposerCalledOnce4() {
        ProducerBean.reset();
        beanManager.fireEvent("Hello");
        Assert.assertEquals(ProducerBean.forthDisposerCalled.get(), 1, "Disposer method called multiple times!");
    }

    @Test
    @SpecAssertion(section = DISPOSER_METHOD_DISPOSED_PARAMETER, id = "ba")
    public void testDisposerCalledOnce5() {
        ProducerBean.reset();
        beanManager.fireEvent("Hello");
        Assert.assertEquals(ProducerBean.fifthDisposerCalled.get(), 1, "Disposer method called multiple times!");
    }

    @Test
    @SpecAssertion(section = DISPOSER_METHOD_DISPOSED_PARAMETER, id = "ba")
    public void testDisposerCalledOnce6() {
        ProducerBean.reset();
        beanManager.fireEvent("Hello");
        Assert.assertEquals(ProducerBean.sixthDisposerCalled.get(), 1, "Disposer method called multiple times!");
    }

}
