/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.bindings.resolution;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.BallBindingLiteral;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.BasketBindingLiteral;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ComplicatedAroundConstructInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ComplicatedInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ComplicatedLifecycleInterceptor;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.ConstructorBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.CreativeBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.LoggedBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.MachineBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.MachineService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.MessageBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.MessageService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.MonitorService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.PingBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.PongBinding;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.RemoteMessageService;
import org.jboss.cdi.tck.interceptors.tests.bindings.resolution.TransactionalBinding;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="1.2")
public class InterceptorBindingResolutionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorBindingResolutionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{ComplicatedInterceptor.class.getName(), ComplicatedLifecycleInterceptor.class.getName(), ComplicatedAroundConstructInterceptor.class.getName()}).up())).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="3.3", id="e"), @SpecAssertion(section="3.4", id="ca"), @SpecAssertion(section="3.4", id="da"), @SpecAssertion(section="3.4", id="db"), @SpecAssertion(section="3.4", id="dc"), @SpecAssertion(section="3.1.2", id="a"), @SpecAssertion(section="3.1.1", id="a"), @SpecAssertion(section="3.1.1", id="b")})
    public void testBusinessMethodInterceptorBindings(MessageService messageService, MonitorService monitorService) {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_INVOKE, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new AnnotationLiteral<PingBinding>(){}, new AnnotationLiteral<PongBinding>(){}, new BallBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertNotNull((Object)messageService);
        ComplicatedInterceptor.reset();
        messageService.ping();
        Assert.assertTrue((boolean)ComplicatedInterceptor.intercepted);
        Assert.assertNotNull((Object)monitorService);
        ComplicatedInterceptor.reset();
        monitorService.ping();
        Assert.assertFalse((boolean)ComplicatedInterceptor.intercepted);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="b"), @SpecAssertion(section="3.4.1", id="a")})
    public void testLifecycleInterceptorBindings() {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.POST_CONSTRUCT, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new BasketBindingLiteral(true, true)}).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.PRE_DESTROY, new Annotation[]{new AnnotationLiteral<MessageBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new BasketBindingLiteral(true, true)}).size(), (int)1);
        ComplicatedLifecycleInterceptor.reset();
        Bean<RemoteMessageService> bean = this.getUniqueBean(RemoteMessageService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        RemoteMessageService remoteMessageService = (RemoteMessageService)bean.create(ctx);
        remoteMessageService.ping();
        bean.destroy((Object)remoteMessageService, ctx);
        Assert.assertTrue((boolean)ComplicatedLifecycleInterceptor.postConstructCalled);
        Assert.assertTrue((boolean)ComplicatedLifecycleInterceptor.preDestroyCalled);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="3.4", id="b"), @SpecAssertion(section="3.4", id="cc")})
    public void testConstructorInterceptorBindings() {
        Assert.assertEquals((int)this.getCurrentManager().resolveInterceptors(InterceptionType.AROUND_CONSTRUCT, new Annotation[]{new AnnotationLiteral<MachineBinding>(){}, new AnnotationLiteral<LoggedBinding>(){}, new AnnotationLiteral<TransactionalBinding>(){}, new AnnotationLiteral<ConstructorBinding>(){}, new AnnotationLiteral<CreativeBinding>(){}}).size(), (int)1);
        ComplicatedAroundConstructInterceptor.reset();
        Bean<MachineService> bean = this.getUniqueBean(MachineService.class, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        bean.create(ctx);
        Assert.assertTrue((boolean)ComplicatedAroundConstructInterceptor.aroundConstructCalled);
    }
}

