/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.application.destroy;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.net.URLEncoder;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.application.destroy.Bar;
import org.jboss.cdi.tck.tests.context.application.destroy.BarInfoServlet;
import org.jboss.cdi.tck.tests.context.application.destroy.Foo;
import org.jboss.cdi.tck.tests.context.application.destroy.FooInitServlet;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@RunAsClient
@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class ApplicationContextDestructionTest
extends AbstractTest {
    private static final String FOO = "foo";
    private static final String BAR = "bar";
    @ArquillianResource
    Deployer deployer;

    @Deployment(name="foo", managed=false, testable=false)
    public static WebArchive createFooTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(Foo.class, FooInitServlet.class, SimpleLogger.class)).build();
    }

    @Deployment(name="bar", managed=false, testable=false)
    public static WebArchive createBarTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().notTestArchive()).withClasses(Bar.class, BarInfoServlet.class, SimpleLogger.class)).build();
    }

    @Test
    public void deployArchives() {
        this.deployer.deploy(FOO);
        this.deployer.deploy(BAR);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", dependsOnMethods={"deployArchives"})
    @SpecAssertion(section="application_context_ee", id="f")
    public void testApplicationContextDestroyed(@ArquillianResource @OperateOnDeployment(value="foo") URL fooContext, @ArquillianResource @OperateOnDeployment(value="bar") URL barContext) throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        webClient.getPage(fooContext + "init?url=" + URLEncoder.encode(barContext.toExternalForm(), "UTF-8"));
        this.deployer.undeploy(FOO);
        TextPage info = (TextPage)webClient.getPage(barContext + "info?action=get");
        Assert.assertEquals((String)info.getContent(), (String)"true");
        this.deployer.undeploy(BAR);
    }
}

