/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.dependent.transientreference;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.dependent.transientreference.Kitchen;
import org.jboss.cdi.tck.tests.context.dependent.transientreference.Meal;
import org.jboss.cdi.tck.tests.context.dependent.transientreference.Spoon;
import org.jboss.cdi.tck.tests.context.dependent.transientreference.Util;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.DependentInstance;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class DependentTransientReferenceDestroyedTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DependentTransientReferenceDestroyedTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="dependent_destruction", id="fb"), @SpecAssertion(section="dependent_destruction", id="fc")})
    public void testConstructorAndInitializer() {
        ActionSequence.reset();
        DependentInstance<Spoon> spoonInstance = this.newDependentInstance(Spoon.class, new Annotation[0]);
        spoonInstance.get().ping();
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)2);
        ActionSequence.getSequence().assertDataContainsAll(Util.buildOwnerId(Spoon.class, true, "constructor"), Util.buildOwnerId(Spoon.class, true, "init"));
        ActionSequence.reset();
        spoonInstance.destroy();
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)2);
        ActionSequence.getSequence().assertDataContainsAll(Util.buildOwnerId(Spoon.class, false, "constructor"), Util.buildOwnerId(Spoon.class, false, "init"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="dependent_destruction", id="fa")})
    public void testProducerMethod() {
        ActionSequence.reset();
        DependentInstance<Meal> mealInstance = this.newDependentInstance(Meal.class, new Annotation[0]);
        Meal meal = mealInstance.get();
        Assert.assertEquals((String)meal.getName(), (String)"soup");
        Assert.assertEquals((int)ActionSequence.getSequenceSize(), (int)1);
        ActionSequence.getSequence().assertDataContainsAll(Util.buildOwnerId(Kitchen.class, true, "producer"));
        mealInstance.destroy();
    }
}

