/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.dependency.resource.remote;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.EnterpriseArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.dependency.resource.remote.Worker;
import org.jboss.cdi.tck.tests.context.passivating.dependency.resource.remote.ejb.FooBean;
import org.jboss.cdi.tck.tests.context.passivating.dependency.resource.remote.ejb.FooRemote;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class ResourcePassivationDependencyTest
extends AbstractTest {
    @Deployment(name="TEST", order=2)
    public static EnterpriseArchive createTestArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().withTestClass(ResourcePassivationDependencyTest.class)).setAsClientMode(false)).withClasses(FooRemote.class, Worker.class)).build();
    }

    @Deployment(name="REMOTE_EJB", order=1, testable=false)
    public static EnterpriseArchive createEjbArchive() {
        return (EnterpriseArchive)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)((EnterpriseArchiveBuilder)new EnterpriseArchiveBuilder().notTestArchive()).noDefaultWebModule().withName("test-ejb.ear")).withEjbModuleName("test-ejb.jar").withClasses(FooBean.class, FooRemote.class)).build();
    }

    @OperateOnDeployment(value="TEST")
    @Test(groups={"javaee-full"})
    @SpecAssertions(value={@SpecAssertion(section="passivation_capable_dependency_ee", id="dd")})
    public void testRemoteSessionBean() throws IOException, ClassNotFoundException {
        Worker worker = this.getContextualReference(Worker.class, new Annotation[0]);
        Assert.assertNotNull((Object)worker);
        String workerId = worker.getId();
        String fooRemoteId = worker.getFoo().getId();
        byte[] serializedWorker = this.passivate(worker);
        Worker workerCopy = (Worker)this.activate(serializedWorker);
        Assert.assertNotNull((Object)workerCopy);
        Assert.assertNotNull((Object)workerCopy.getFoo());
        Assert.assertEquals((String)workerCopy.getId(), (String)workerId);
        Assert.assertEquals((String)workerCopy.getFoo().getId(), (String)fooRemoteId);
    }
}

