/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.passivating.dependency.resource.webservice;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.passivating.dependency.resource.webservice.PassivatedBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class WebResourcePassivationCapableDependencyTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(WebResourcePassivationCapableDependencyTest.class)).build();
    }

    @Test(groups={"javaee-full", "jaxws"})
    @SpecAssertion(section="passivation_capable_dependency_ee", id="de")
    public void testWebResourcePassivated() throws IOException, ClassNotFoundException {
        PassivatedBean bean = this.getContextualReference(PassivatedBean.class, new Annotation[0]);
        Assert.assertNotNull((Object)bean);
        Assert.assertNotNull((Object)bean.getHelloWeb());
        String beanId = bean.getId();
        byte[] serializedBean = this.passivate(bean);
        PassivatedBean beanCopy = (PassivatedBean)this.activate(serializedBean);
        String message = beanCopy.getHelloWeb().sayHello("John");
        Assert.assertEquals((String)beanCopy.getId(), (String)beanId);
        Assert.assertEquals((String)message, (String)"Hello John.");
    }
}

