/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.bean.types.enterprise;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Animal;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Bird;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Cobra;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Creature;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.LegendaryCreature;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.LegendaryLocal;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.LoginActionBean;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Mammal;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Mock;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.MockLoginActionBean;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Snake;
import org.jboss.cdi.tck.tests.definition.bean.types.enterprise.Vulture;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class SessionBeanTypesTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanTypesTest.class)).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_bean_types", id="aa"), @SpecAssertion(section="session_bean_types", id="ba"), @SpecAssertion(section="session_bean_types", id="c")})
    public void testGenericHierarchyBeanTypes() {
        Bean<Vulture> vultureBean = this.getUniqueBean(Vulture.class, new Annotation[0]);
        org.testng.Assert.assertNotNull(vultureBean);
        org.testng.Assert.assertEquals((int)vultureBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches(vultureBean.getTypes(), new Type[]{Object.class, Vulture.class, new TypeLiteral<Bird<Integer>>(){}.getType()});
        TypeLiteral<Mammal<String>> mammalLiteral = new TypeLiteral<Mammal<String>>(){};
        Bean<Mammal<String>> tigerBean = this.getUniqueBean(mammalLiteral, new Annotation[0]);
        org.testng.Assert.assertNotNull(tigerBean);
        org.testng.Assert.assertEquals((int)tigerBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches(tigerBean.getTypes(), new Type[]{Object.class, new TypeLiteral<Animal<String>>(){}.getType(), mammalLiteral.getType()});
        Bean<LegendaryCreature> creatureBean = this.getUniqueBean(LegendaryCreature.class, new Annotation[0]);
        org.testng.Assert.assertNotNull(creatureBean);
        org.testng.Assert.assertEquals((int)creatureBean.getTypes().size(), (int)4);
        Assert.assertTypeSetMatches(creatureBean.getTypes(), new Type[]{Object.class, LegendaryCreature.class, LegendaryLocal.class, Creature.class});
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="session_bean_types", id="aa"), @SpecAssertion(section="session_bean_types", id="ba"), @SpecAssertion(section="session_bean_types", id="c")})
    public void testSessionBeanWithBothLocalInterfaceAndNoInterfaceView() {
        Bean<LegendaryCreature> creatureBean = this.getUniqueBean(LegendaryCreature.class, new Annotation[0]);
        org.testng.Assert.assertNotNull(creatureBean);
        org.testng.Assert.assertEquals((int)creatureBean.getTypes().size(), (int)4);
        Assert.assertTypeSetMatches(creatureBean.getTypes(), new Type[]{Object.class, LegendaryCreature.class, LegendaryLocal.class, Creature.class});
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_bean_types", id="ba")
    public void testSessionBeanExtendingSessionBeanWithLocalClientView() {
        Bean<MockLoginActionBean> loginBean = this.getUniqueBean(MockLoginActionBean.class, new Annotation[]{new AnnotationLiteral<Mock>(){}});
        org.testng.Assert.assertNotNull(loginBean);
        org.testng.Assert.assertEquals((int)loginBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches(loginBean.getTypes(), new Type[]{Object.class, LoginActionBean.class, MockLoginActionBean.class});
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="session_bean_types", id="ba")
    public void testSessionBeanWithNoInterfaceView() {
        Bean<Cobra> cobraBean = this.getUniqueBean(Cobra.class, new Annotation[0]);
        org.testng.Assert.assertNotNull(cobraBean);
        org.testng.Assert.assertEquals((int)cobraBean.getTypes().size(), (int)3);
        Assert.assertTypeSetMatches(cobraBean.getTypes(), new Type[]{Object.class, Cobra.class, Snake.class});
    }
}

