/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.definition.stereotype;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.definition.stereotype.BorderCollie;
import org.jboss.cdi.tck.tests.definition.stereotype.Chihuahua;
import org.jboss.cdi.tck.tests.definition.stereotype.EnglishBorderCollie;
import org.jboss.cdi.tck.tests.definition.stereotype.HighlandCow;
import org.jboss.cdi.tck.tests.definition.stereotype.LongHairedDog;
import org.jboss.cdi.tck.tests.definition.stereotype.MexicanChihuahua;
import org.jboss.cdi.tck.tests.definition.stereotype.MiniatureClydesdale;
import org.jboss.cdi.tck.tests.definition.stereotype.Moose;
import org.jboss.cdi.tck.tests.definition.stereotype.Reindeer;
import org.jboss.cdi.tck.tests.definition.stereotype.ShetlandPony;
import org.jboss.cdi.tck.tests.definition.stereotype.Springbok;
import org.jboss.cdi.tck.tests.definition.stereotype.Tame;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class StereotypeDefinitionTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(StereotypeDefinitionTest.class)).withBeansXml("beans.xml")).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotype_default_scope", id="aa"), @SpecAssertion(section="declaring_bean_scope", id="c")})
    public void testStereotypeWithScopeType() {
        assert (this.getBeans(Moose.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(Moose.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotype_default_scope", id="aa"), @SpecAssertion(section="default_scope", id="b")})
    public void testStereotypeWithoutScopeType() {
        assert (this.getBeans(Reindeer.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(Reindeer.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="stereotypes", id="c"), @SpecAssertion(section="defining_new_stereotype", id="b"), @SpecAssertion(section="specify_stereotype_interceptor_bindings", id="a")})
    public void testOneStereotypeAllowed() {
        Bean<LongHairedDog> bean = this.getBeans(LongHairedDog.class, new Annotation[0]).iterator().next();
        assert (bean.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_stereotypes", id="e"), @SpecAssertion(section="stereotypes", id="d")})
    public void testMultipleStereotypesAllowed() {
        assert (this.getBeans(HighlandCow.class, TAME_LITERAL).size() == 1);
        Bean<HighlandCow> highlandCow = this.getBeans(HighlandCow.class, TAME_LITERAL).iterator().next();
        assert (highlandCow.getName() == null);
        assert (highlandCow.getQualifiers().contains(TAME_LITERAL));
        assert (highlandCow.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_stereotypes", id="e"), @SpecAssertion(section="default_scope", id="e")})
    public void testExplicitScopeOverridesMergedScopesFromMultipleStereotype() {
        assert (this.getBeans(Springbok.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(Springbok.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="ab")
    public void testStereotypeDeclaredInheritedIsInherited() throws Exception {
        assert (this.getBeans(BorderCollie.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="aba")
    public void testStereotypeNotDeclaredInheritedIsNotInherited() {
        assert (this.getBeans(ShetlandPony.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(ShetlandPony.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="ah")
    public void testStereotypeDeclaredInheritedIsIndirectlyInherited() {
        assert (this.getBeans(EnglishBorderCollie.class, new Annotation[0]).iterator().next().getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="aha")
    public void testStereotypeNotDeclaredInheritedIsNotIndirectlyInherited() {
        assert (this.getBeans(MiniatureClydesdale.class, new Annotation[0]).size() == 1);
        assert (this.getBeans(MiniatureClydesdale.class, new Annotation[0]).iterator().next().getScope().equals(Dependent.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="hhh")
    public void testStereotypeScopeIsOverriddenByInheritedScope() {
        assert (this.getBeans(Chihuahua.class, new Annotation[0]).iterator().next().getScope().equals(SessionScoped.class));
    }

    @Test
    @SpecAssertion(section="type_level_inheritance", id="hhi")
    public void testStereotypeScopeIsOverriddenByIndirectlyInheritedScope() {
        assert (this.getBeans(MexicanChihuahua.class, new Annotation[0]).iterator().next().getScope().equals(SessionScoped.class));
    }
}

