/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.transactional;

import java.util.List;
import javax.enterprise.event.TransactionPhase;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.transactional.AccountService;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "persistence"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class TransactionalObserverTest
extends AbstractTest {
    private static final SimpleLogger logger = new SimpleLogger(TransactionalObserverTest.class);
    @Inject
    AccountService accountService;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(TransactionalObserverTest.class)).withDefaultPersistenceXml()).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="transactional_observer_methods", id="b"), @SpecAssertion(section="transactional_observer_methods", id="c"), @SpecAssertion(section="transactional_observer_methods", id="d"), @SpecAssertion(section="transactional_observer_methods", id="e"), @SpecAssertion(section="transactional_observer_methods", id="gaa"), @SpecAssertion(section="observer_notification", id="b")})
    public void testSucessfullTransaction() throws Exception {
        logger.log("testSucessfullTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawSuccesTransaction(1);
        List<String> phases = ActionSequence.getSequenceData();
        Assert.assertEquals((int)phases.size(), (int)5);
        Assert.assertEquals((String)phases.get(0), (String)TransactionPhase.IN_PROGRESS.name());
        Assert.assertEquals((String)phases.get(1), (String)"checkpoint");
        Assert.assertEquals((String)phases.get(2), (String)TransactionPhase.BEFORE_COMPLETION.name());
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_SUCCESS.name()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_COMPLETION.name()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="transactional_observer_methods", id="b"), @SpecAssertion(section="transactional_observer_methods", id="c"), @SpecAssertion(section="transactional_observer_methods", id="d"), @SpecAssertion(section="transactional_observer_methods", id="e"), @SpecAssertion(section="transactional_observer_methods", id="gaa"), @SpecAssertion(section="observer_notification", id="b")})
    public void testFailedTransaction() throws Exception {
        logger.log("testFailedTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawFailedTransaction(2);
        List<String> phases = ActionSequence.getSequenceData();
        Assert.assertEquals((int)phases.size(), (int)4);
        Assert.assertEquals((String)phases.get(0), (String)TransactionPhase.IN_PROGRESS.name());
        Assert.assertEquals((String)phases.get(1), (String)"checkpoint");
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_FAILURE.name()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_COMPLETION.name()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="transactional_observer_methods", id="a"), @SpecAssertion(section="observer_notification", id="b")})
    public void testNoTransaction() throws Exception {
        logger.log("testNoTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawNoTransaction(3);
        List<String> sequence = ActionSequence.getSequenceData();
        Assert.assertEquals((int)sequence.size(), (int)6);
        Assert.assertEquals((String)sequence.get(sequence.size() - 1), (String)"checkpoint");
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_notification", id="bda")})
    public void testObserverFailedTransaction() throws Exception {
        logger.log("testObserverFailedTransaction", new Object[0]);
        ActionSequence.reset();
        this.accountService.withdrawObserverFailedTransaction(2);
        List<String> phases = ActionSequence.getSequenceData();
        Assert.assertEquals((int)phases.size(), (int)5);
        Assert.assertEquals((String)phases.get(0), (String)TransactionPhase.IN_PROGRESS.name());
        Assert.assertEquals((String)phases.get(1), (String)TransactionPhase.IN_PROGRESS.name());
        Assert.assertEquals((String)phases.get(2), (String)"checkpoint");
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_FAILURE.name()));
        Assert.assertTrue((boolean)phases.contains(TransactionPhase.AFTER_COMPLETION.name()));
    }
}

