/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.lookup.injection.enterprise;

import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.DeluxeHenHouseLocal;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.FarmLocal;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.InjectedSessionBeanLocal;
import org.jboss.cdi.tck.tests.lookup.injection.enterprise.MegaPoorHenHouseLocal;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class SessionBeanInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionBeanInjectionTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="a"), @SpecAssertion(section="fields_initializer_methods_ee", id="aa"), @SpecAssertion(section="fields_initializer_methods_ee", id="ab"), @SpecAssertion(section="fields_initializer_methods_ee", id="ba"), @SpecAssertion(section="fields_initializer_methods_ee", id="be")})
    public void testInjectionOnContextualSessionBean() {
        assert (this.getContextualReference(FarmLocal.class, new Annotation[0]).isInjectionPerformedCorrectly());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="c"), @SpecAssertion(section="fields_initializer_methods_ee", id="ak"), @SpecAssertion(section="fields_initializer_methods_ee", id="al")})
    public void testInjectionOnNonContextualSessionBean() {
        assert (this.getContextualReference(InjectedSessionBeanLocal.class, new Annotation[0]).getFarm().isInjectionPerformedCorrectly());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="injection_ee", id="ed"), @SpecAssertion(section="fields_initializer_methods_ee", id="ao"), @SpecAssertion(section="fields_initializer_methods_ee", id="ap")})
    public void testInjectionOnEJBInterceptor() {
        assert (this.getContextualReference(FarmLocal.class, new Annotation[0]).getAnimalCount() == 2);
        assert (this.getContextualReference(InjectedSessionBeanLocal.class, new Annotation[0]).getFarm().getAnimalCount() == 2);
    }

    @Test
    @SpecAssertion(section="member_level_inheritance_ee", id="ab")
    public void testFieldDeclaredInSuperclassInjected() {
        DeluxeHenHouseLocal henHouse = this.getContextualReference(DeluxeHenHouseLocal.class, new Annotation[0]);
        assert (henHouse.getFox() != null);
        assert (henHouse.getFox().getName().equals("gavin"));
    }

    @Test
    @SpecAssertion(section="member_level_inheritance_ee", id="ad")
    public void testFieldDeclaredInSuperclassIndirectlyInjected() {
        MegaPoorHenHouseLocal henHouse = this.getContextualReference(MegaPoorHenHouseLocal.class, new Annotation[0]);
        assert (henHouse.getFox() != null);
        assert (henHouse.getFox().getName().equals("gavin"));
    }
}

