/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.discovery;

import java.lang.annotation.Annotation;
import javax.enterprise.inject.spi.Extension;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.Beans11DescriptorImpl;
import org.jboss.cdi.tck.tests.deployment.discovery.Alpha;
import org.jboss.cdi.tck.tests.deployment.discovery.Binding;
import org.jboss.cdi.tck.tests.deployment.discovery.Bravo;
import org.jboss.cdi.tck.tests.deployment.discovery.Charlie;
import org.jboss.cdi.tck.tests.deployment.discovery.Decorator1;
import org.jboss.cdi.tck.tests.deployment.discovery.Decorator2;
import org.jboss.cdi.tck.tests.deployment.discovery.Delta;
import org.jboss.cdi.tck.tests.deployment.discovery.Echo;
import org.jboss.cdi.tck.tests.deployment.discovery.EchoNotABean;
import org.jboss.cdi.tck.tests.deployment.discovery.Foxtrot;
import org.jboss.cdi.tck.tests.deployment.discovery.Golf;
import org.jboss.cdi.tck.tests.deployment.discovery.Hotel;
import org.jboss.cdi.tck.tests.deployment.discovery.India;
import org.jboss.cdi.tck.tests.deployment.discovery.Interceptor1;
import org.jboss.cdi.tck.tests.deployment.discovery.Interceptor2;
import org.jboss.cdi.tck.tests.deployment.discovery.Juliet;
import org.jboss.cdi.tck.tests.deployment.discovery.JulietNotABean;
import org.jboss.cdi.tck.tests.deployment.discovery.Kilo;
import org.jboss.cdi.tck.tests.deployment.discovery.LegacyAlpha;
import org.jboss.cdi.tck.tests.deployment.discovery.LegacyBravo;
import org.jboss.cdi.tck.tests.deployment.discovery.LegacyExtension;
import org.jboss.cdi.tck.tests.deployment.discovery.Lima;
import org.jboss.cdi.tck.tests.deployment.discovery.Mike;
import org.jboss.cdi.tck.tests.deployment.discovery.MyNormalContext;
import org.jboss.cdi.tck.tests.deployment.discovery.MyNormalScope;
import org.jboss.cdi.tck.tests.deployment.discovery.MyPseudoContext;
import org.jboss.cdi.tck.tests.deployment.discovery.MyPseudoScope;
import org.jboss.cdi.tck.tests.deployment.discovery.MyStereotype;
import org.jboss.cdi.tck.tests.deployment.discovery.November;
import org.jboss.cdi.tck.tests.deployment.discovery.Ping;
import org.jboss.cdi.tck.tests.deployment.discovery.ScopesExtension;
import org.jboss.cdi.tck.tests.deployment.discovery.VerifyingExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans10.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class BeanDiscoveryTest
extends AbstractTest {
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        JavaArchive alpha = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Alpha.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ALL).exportAsString()), "beans.xml");
        JavaArchive bravo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Bravo.class)).addAsManifestResource((Asset)new StringAsset(""), "beans.xml");
        JavaArchive charlie = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Charlie.class)).addAsManifestResource((Asset)new StringAsset(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).exportAsString()), "beans.xml");
        JavaArchive delta = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Delta.class, Golf.class, India.class, Kilo.class, Mike.class, Interceptor1.class, Decorator1.class});
        JavaArchive echo = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Echo.class, EchoNotABean.class, Hotel.class, Juliet.class, JulietNotABean.class, Lima.class, November.class, Interceptor2.class, Decorator2.class})).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.ANNOTATED).exportAsString()), "beans.xml");
        JavaArchive foxtrot = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Foxtrot.class)).addAsManifestResource((Asset)new StringAsset(Beans11DescriptorImpl.newBeans11Descriptor().setBeanDiscoveryMode(Beans11DescriptorImpl.BeanDiscoveryMode.NONE).exportAsString()), "beans.xml");
        JavaArchive legacy = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{LegacyExtension.class, LegacyAlpha.class, LegacyBravo.class})).addAsServiceProvider(Extension.class, new Class[]{LegacyExtension.class});
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClass(BeanDiscoveryTest.class)).withClasses(VerifyingExtension.class, ScopesExtension.class, Binding.class, MyNormalScope.class, MyPseudoScope.class, MyNormalContext.class, MyPseudoContext.class, MyStereotype.class)).withExtensions(VerifyingExtension.class, ScopesExtension.class)).withLibrary(Ping.class)).withLibraries(alpha, bravo, charlie, delta, echo, foxtrot, legacy)).build();
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ba"), @SpecAssertion(section="type_discovery_steps", id="a")})
    public void testExplicitBeanArchiveModeAll(Alpha alpha) {
        this.assertDiscoveredAndAvailable(alpha, Alpha.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bb"), @SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="type_discovery_steps", id="a")})
    public void testExplicitBeanArchiveEmptyDescriptor(Bravo bravo) {
        this.assertDiscoveredAndAvailable(bravo, Bravo.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="bean_archive", id="bc"), @SpecAssertion(section="type_discovery_steps", id="a")})
    public void testExplicitBeanArchiveLegacyDescriptor(Charlie charlie) {
        this.assertDiscoveredAndAvailable(charlie, Charlie.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="type_discovery_steps", id="b"), @SpecAssertion(section="bean_defining_annotations", id="ba"), @SpecAssertion(section="bean_defining_annotations", id="bb")})
    public void testNormalScopeImplicitBeanArchiveNoDescriptor(Delta delta, Golf golf) {
        this.assertDiscoveredAndAvailable(delta, Delta.class);
        this.assertDiscoveredAndAvailable(golf, Golf.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ca"), @SpecAssertion(section="type_discovery_steps", id="b"), @SpecAssertion(section="bean_defining_annotations", id="ba"), @SpecAssertion(section="bean_defining_annotations", id="bb")})
    public void testNormalScopeImplicitBeanArchiveModeAnnotated(Echo echo, Hotel hotel) {
        this.assertDiscoveredAndAvailable(echo, Echo.class);
        this.assertNotDiscoveredAndNotAvailable(EchoNotABean.class);
        this.assertDiscoveredAndAvailable(hotel, Hotel.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="type_discovery_steps", id="b"), @SpecAssertion(section="bean_defining_annotations", id="bf")})
    public void testDependentScopeImplicitBeanArchiveNoDescriptor(India india) {
        this.assertDiscoveredAndAvailable(india, India.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="type_discovery_steps", id="b"), @SpecAssertion(section="bean_defining_annotations", id="bf"), @SpecAssertion(section="bean_defining_annotations", id="ca")})
    public void testPseudoScopeImplicitBeanArchiveModeAnnotated(Juliet juliet) {
        this.assertDiscoveredAndAvailable(juliet, Juliet.class);
        this.assertNotDiscoveredAndNotAvailable(JulietNotABean.class);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_defining_annotations", id="bc"), @SpecAssertion(section="type_discovery_steps", id="b")})
    public void testInterceptorIsBeanDefiningAnnotation() {
        this.assertDiscovered(Interceptor1.class);
        this.assertDiscovered(Interceptor2.class);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_defining_annotations", id="bd"), @SpecAssertion(section="type_discovery_steps", id="b")})
    public void testDecoratorIsBeanDefiningAnnotation() {
        this.assertDiscovered(Decorator1.class);
        this.assertDiscovered(Decorator2.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="type_discovery_steps", id="b"), @SpecAssertion(section="bean_defining_annotations", id="be"), @SpecAssertion(section="bean_defining_annotations", id="cb")})
    public void testStereotypeImplicitBeanArchiveNoDescriptor(Mike mike) {
        this.assertDiscoveredAndAvailable(mike, Mike.class);
        this.assertDiscovered(Kilo.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="type_discovery_steps", id="b"), @SpecAssertion(section="bean_defining_annotations", id="be"), @SpecAssertion(section="bean_defining_annotations", id="cb")})
    public void testStereotypeImplicitBeanArchiveModeAnnotated(November november) {
        this.assertDiscoveredAndAvailable(november, November.class);
        this.assertDiscovered(Lima.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="oa")})
    public void testNoBeanArchiveModeNone() {
        this.assertNotDiscoveredAndNotAvailable(Foxtrot.class);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER", groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="bean_archive", id="ob")})
    public void testNotBeanArchiveExtension(LegacyAlpha legacyAlpha) {
        this.assertDiscoveredAndAvailable(legacyAlpha, LegacyAlpha.class);
        this.assertNotDiscoveredAndNotAvailable(LegacyBravo.class);
    }

    private <T extends Ping> void assertDiscoveredAndAvailable(T reference, Class<T> clazz) {
        this.assertDiscovered(clazz);
        Assert.assertNotNull(reference);
        reference.pong();
        this.getUniqueBean(clazz, new Annotation[0]);
    }

    private void assertDiscovered(Class<?> clazz) {
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(clazz), (String)(clazz.getSimpleName() + " not discovered."));
    }

    private <T> void assertNotDiscoveredAndNotAvailable(Class<T> clazz) {
        Assert.assertFalse((boolean)this.extension.getObservedAnnotatedTypes().contains(clazz));
        Assert.assertTrue((boolean)this.getBeans(clazz, new Annotation[0]).isEmpty());
    }
}

