/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.context.async;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.UserTransaction;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.context.async.AsyncMessageObserver;
import org.jboss.cdi.tck.tests.event.observer.context.async.Counter;
import org.jboss.cdi.tck.tests.event.observer.context.async.Message;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class AsyncObserverMethodInvocationContextTest
extends AbstractTest {
    @Inject
    UserTransaction userTransaction;
    @Inject
    Event<Message> event;
    @Inject
    Event<String> stringEvent;
    @Inject
    Counter counter;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AsyncObserverMethodInvocationContextTest.class)).build();
    }

    @Test
    @SpecAssertion(section="observer_method_invocation_context", id="ab")
    public void testAsyncObserverIsCalledInNewTransactionContext() throws Exception {
        this.userTransaction.begin();
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.event.fireAsync((Object)new Message()).thenAccept(queue::offer);
        Message message = (Message)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)message);
        Assert.assertEquals((int)6, (int)AsyncMessageObserver.status.get());
        this.userTransaction.commit();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_invocation_context", id="aa"), @SpecAssertion(section="request_context_ee", id="c")})
    public void testAsyncObserverIsCalledInNewRequestContext() throws Exception {
        this.counter.increment();
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.stringEvent.fireAsync((Object)new String()).thenAccept(queue::offer);
        String string = (String)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)string);
        Assert.assertTrue((boolean)AsyncMessageObserver.requestScopeActive.get());
        Assert.assertTrue((boolean)AsyncMessageObserver.counterIsZero.get());
    }
}

