/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import java.net.URL;
import javax.xml.namespace.QName;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget.ContainerEventTest;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget.Cowboy;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget.CowboyEndpoint;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget.CowboyEndpointService;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget.ProcessInjectionTargetObserver;
import org.jboss.cdi.tck.tests.extensions.lifecycle.processInjectionTarget.Sheep;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.jsp22.JspConfigType;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class WrappedInjectionTargetTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;
    private static final String LIBRARY_TLD_PATH = "WEB-INF/TestLibrary.tld";
    private static final String TEST_URI = "http://processInjectionTarget.lifecycle.extensions.tests.tck.cdi.jboss.org/";

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(WrappedInjectionTargetTest.class)).withExtension(ProcessInjectionTargetObserver.class)).withExcludedClass(ContainerEventTest.class.getName())).withWebResource("TestLibrary.tld", LIBRARY_TLD_PATH)).withWebResource("index.jsp", "index.jsp")).withWebXml((WebAppDescriptor)((WebAppDescriptor)((WebAppDescriptor)((JspConfigType)((WebAppDescriptor)Descriptors.create(WebAppDescriptor.class)).createJspConfig().createTaglib().taglibUri(TEST_URI).taglibLocation(LIBRARY_TLD_PATH).up()).up()).createServlet().servletName("Cowboy").servletClass(CowboyEndpoint.class.getName()).loadOnStartup(Integer.valueOf(1)).up()).createServletMapping().servletName("Cowboy").urlPattern(new String[]{"/cowboy"}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="eb")})
    public void testWrappedInjectionTargetUsedForSessionBean() throws Exception {
        TextPage page = this.invokeContextPath("test?type=sessionbean", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="ec")})
    public void testWrappedInjectionTargetUsedForServletListener() throws Exception {
        TextPage page = this.invokeContextPath("test?type=listener", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains(Sheep.class.getName()));
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="ed")})
    public void testWrappedInjectionTargetUsedForTagHandler() throws Exception {
        HtmlPage page = this.invokeContextPath("index.jsp", HtmlPage.class);
        Assert.assertTrue((boolean)page.asText().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="ee")})
    public void testWrappedInjectionTargetUsedForTagLibraryListener() throws Exception {
        TextPage page = this.invokeContextPath("test?type=taglibrary", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="eh")})
    public void testWrappedInjectionTargetUsedForServlet() throws Exception {
        TextPage page = this.invokeContextPath("test?type=servlet", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="ef")})
    public void testWrappedInjectionTargetUsedForEjbInterceptor() throws Exception {
        TextPage page = this.invokeContextPath("test?type=interceptor", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="eg")})
    public void testWrappedInjectionTargetUsedForWsEndpoint() throws Exception {
        URL wsdlLocation = new URL(this.contextPath.toExternalForm() + "cowboy?wsdl");
        CowboyEndpointService endpointService = new CowboyEndpointService(wsdlLocation, new QName(TEST_URI, "Cowboy"));
        Cowboy cowboy = (Cowboy)endpointService.getPort(Cowboy.class);
        cowboy.catchSheep();
        TextPage page = this.invokeContextPath("test?type=wsendpoint", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="process_injection_target_ee", id="ei")})
    public void testWrappedInjectionTargetIsUsedForFilter() throws Exception {
        TextPage page = this.invokeContextPath("test?type=filter", TextPage.class);
        Assert.assertTrue((boolean)page.getContent().contains("true"));
    }

    public <T extends Page> T invokeContextPath(String path, Class<T> type) throws Exception {
        WebClient webClient = new WebClient();
        webClient.setThrowExceptionOnFailingStatusCode(true);
        if (type.equals(TextPage.class)) {
            TextPage page = (TextPage)webClient.getPage(this.contextPath + path);
            return (T)((Page)type.cast(page));
        }
        HtmlPage page = (HtmlPage)webClient.getPage(this.contextPath + path);
        return (T)((Page)type.cast(page));
    }
}

