/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.container;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.CDIProvider;
import org.jboss.arquillian.container.se.api.ClassPath;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.cdi.tck.tests.se.container.Bar;
import org.jboss.cdi.tck.tests.se.container.Foo;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"se"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class BootstrapSEContainerTest
extends Arquillian {
    private static final String IMPLICIT_SCAN_KEY = "javax.enterprise.inject.scan.implicit";

    @Deployment
    public static Archive<?> deployment() {
        JavaArchive testArchive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{Foo.class, BootstrapSEContainerTest.class})).addAsResource((Asset)EmptyAsset.INSTANCE, "META-INF/beans.xml");
        JavaArchive implicitArchive = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClass(Bar.class);
        return ClassPath.builder().add(new JavaArchive[]{testArchive, implicitArchive}).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bootstrap-se", id="a"), @SpecAssertion(section="init_container", id="a"), @SpecAssertion(section="stop_container", id="a")})
    public void testContainerIsInitialized() {
        CDIProvider cdiProvider = CDI.getCDIProvider();
        try (CDI cdi = cdiProvider.initialize();){
            Assert.assertTrue((boolean)cdiProvider.isInitialized());
            Foo foo = (Foo)cdi.select(Foo.class, new Annotation[0]).get();
            Assert.assertNotNull((Object)foo);
            foo.ping();
        }
        Assert.assertFalse((boolean)cdiProvider.isInitialized());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    @SpecAssertions(value={@SpecAssertion(section="stop_container", id="b")})
    public void testContainerShutdownMethodOnNotInitializedContainer() {
        CDIProvider cdiProvider = CDI.getCDIProvider();
        CDI cdi = cdiProvider.initialize();
        cdi.shutdown();
        cdi.shutdown();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bootstrap-se", id="a"), @SpecAssertion(section="init_container", id="b")})
    public void testInvocationOfInitializedMethodReturnsNewCDIInstance() {
        CDIProvider cdiProvider = CDI.getCDIProvider();
        CDI cdi1 = cdiProvider.initialize();
        Assert.assertNotNull((Object)cdi1);
        cdi1.shutdown();
        CDI cdi2 = cdiProvider.initialize();
        Assert.assertNotNull((Object)cdi2);
        cdi2.shutdown();
        Assert.assertNotEquals((Object)cdi1, (Object)cdi2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bootstrap-se", id="a"), @SpecAssertion(section="bean_archive_se", id="b")})
    public void testImplicitArchiveDiscovered() {
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put(IMPLICIT_SCAN_KEY, Boolean.TRUE);
        CDIProvider cdiProvider = CDI.getCDIProvider();
        try (CDI cdi = cdiProvider.initialize(params);){
            Bar bar = (Bar)cdi.select(Bar.class, new Annotation[0]).get();
            Assert.assertNotNull((Object)bar);
            bar.ping();
        }
    }
}

