/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.HtmlSpan;
import com.gargoylesoftware.htmlunit.html.HtmlSubmitInput;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.context.conversation.AbstractConversationTest;
import org.jboss.cdi.tck.tests.context.conversation.BuiltInConversation;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;
import org.jboss.cdi.tck.tests.context.conversation.CloudController;
import org.jboss.cdi.tck.tests.context.conversation.ConversationContextObserver;
import org.jboss.cdi.tck.tests.context.conversation.ConversationStatusServlet;
import org.jboss.cdi.tck.tests.context.conversation.ConversationTestPhaseListener;
import org.jboss.cdi.tck.tests.context.conversation.Cumulus;
import org.jboss.cdi.tck.tests.context.conversation.OutermostFilter;
import org.jboss.cdi.tck.tests.context.conversation.Storm;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class ClientConversationContextTest
extends AbstractConversationTest {
    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassDefinition(ClientConversationContextTest.class)).withClasses(Storm.class, ConversationTestPhaseListener.class, ConversationStatusServlet.class, Cloud.class, CloudController.class, OutermostFilter.class, Cumulus.class, BuiltInConversation.class, ConversationContextObserver.class)).withWebResource("home.xhtml")).withWebResource("cloud.xhtml")).withWebResource("clouds.xhtml")).withWebResource("cumulus.xhtml")).withWebResource("builtin.xhtml")).withWebResource("error.xhtml")).withWebResource("storm.xhtml")).withWebResource("rain.xhtml")).withWebResource("faces-config.xml", "/WEB-INF/faces-config.xml")).withWebXml("web.xml")).build();
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="hb"), @SpecAssertion(section="conversation_context_ee", id="o")})
    public void testConversationIdSetByContainerIsUnique() throws Exception {
        WebClient client = new WebClient();
        HtmlPage storm = (HtmlPage)client.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        String c1 = this.getCid((Page)storm);
        storm = (HtmlPage)client.getPage(this.getPath("storm.jsf"));
        beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        String c2 = this.getCid((Page)storm);
        Assert.assertNotEquals((Object)c1, (Object)c2);
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="j")
    public void testTransientConversationInstancesDestroyedAtRequestEnd() throws Exception {
        WebClient client = new WebClient();
        this.resetCloud(client);
        this.resetConversationContextObserver(client);
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cloud.jsf"));
        Assert.assertFalse((boolean)this.isLongRunning((Page)page));
        Assert.assertTrue((boolean)this.isCloudDestroyed(client));
        Assert.assertTrue((boolean)this.isConversationContextDestroyed(client));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="k")
    public void testLongRunningConversationInstancesNotDestroyedAtRequestEnd() throws Exception {
        WebClient client = new WebClient();
        HtmlPage storm = (HtmlPage)client.getPage(this.getPath("storm.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(storm, HtmlSubmitInput.class, "beginConversationButton");
        storm = (HtmlPage)beginConversationButton.click();
        this.resetCloud(client);
        client.getPage(this.getPath("cloud.jsf", this.getCid((Page)storm)));
        assert (!this.isCloudDestroyed(client));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="p")
    public void testConversationsDontCrossSessionBoundary1() throws Exception {
        WebClient client = new WebClient();
        client.setThrowExceptionOnFailingStatusCode(false);
        HtmlPage rain = (HtmlPage)client.getPage(this.getPath("rain.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(rain, HtmlSubmitInput.class, "beginConversationButton");
        rain = (HtmlPage)beginConversationButton.click();
        String cid = this.getCid((Page)rain);
        HtmlSubmitInput rainButton = this.getFirstMatchingElement(rain, HtmlSubmitInput.class, "rain");
        rain = (HtmlPage)rainButton.click();
        rain = (HtmlPage)client.getPage(this.getPath("rain.jsf", cid));
        Assert.assertTrue((boolean)this.hasRained((Page)rain));
        this.invalidateSession(client);
        this.verifyNonexistentConversationExceptionThrown(client.getPage(this.getPath("rain.jsf", cid)));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="p")
    public void testConversationsDontCrossSessionBoundary2() throws Exception {
        WebClient client = new WebClient();
        HtmlPage rain = (HtmlPage)client.getPage(this.getPath("rain.jsf"));
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(rain, HtmlSubmitInput.class, "beginConversationButton");
        rain = (HtmlPage)beginConversationButton.click();
        String cid = this.getCid((Page)rain);
        HtmlSubmitInput rainButton = this.getFirstMatchingElement(rain, HtmlSubmitInput.class, "rain");
        rain = (HtmlPage)rainButton.click();
        rain = (HtmlPage)client.getPage(this.getPath("rain.jsf", cid));
        Assert.assertTrue((boolean)this.hasRained((Page)rain));
        WebClient client2 = new WebClient();
        client2.setThrowExceptionOnFailingStatusCode(false);
        this.verifyNonexistentConversationExceptionThrown(client2.getPage(this.getPath("rain.jsf", cid)));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="a")
    public void testConversationActiveDuringNonFacesRequest() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cloud.jsf"));
        HtmlSpan span = this.getFirstMatchingElement(page, HtmlSpan.class, "cloudName");
        assert (span.getTextContent().equals(Cloud.NAME));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="f")
    public void testConversationBeginMakesConversationLongRunning() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationButton");
        page = (HtmlPage)beginConversationButton.click();
        assert (this.isLongRunning((Page)page).booleanValue());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation", id="r")
    public void testBeginAlreadyLongRunningConversationThrowsException() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationButton");
        page = (HtmlPage)beginConversationButton.click();
        assert (this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton2 = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationAndSwallowException");
        page = (HtmlPage)beginConversationButton2.click();
        assert (page.getBody().getTextContent().contains("Hello world!"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation", id="s")
    public void testBeginConversationWithExplicitIdAlreadyUsedByDifferentConversation() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        Assert.assertFalse((boolean)this.isLongRunning((Page)page));
        HtmlSubmitInput beginConversationButton = (HtmlSubmitInput)page.getElementById("form:beginNextConversationIdentifiedByCustomIdentifier");
        page = (HtmlPage)beginConversationButton.click();
        Assert.assertTrue((boolean)this.isLongRunning((Page)page));
        page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        beginConversationButton = (HtmlSubmitInput)page.getElementById("form:beginConversationIdentifiedByCustomIdentifierAndSwallowException");
        page = (HtmlPage)beginConversationButton.click();
        Assert.assertTrue((boolean)page.getBody().getTextContent().contains("Hello world!"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="g"), @SpecAssertion(section="conversation", id="k"), @SpecAssertion(section="conversation", id="o")})
    public void testConversationEndMakesConversationTransient() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationButton");
        page = (HtmlPage)beginConversationButton.click();
        assert (this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput endConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "endConversationButton");
        page = (HtmlPage)endConversationButton.click();
        assert (!this.isLongRunning((Page)page).booleanValue());
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation", id="q")
    public void testEndTransientConversationThrowsException() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput endConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "endConversationAndSwallowException");
        page = (HtmlPage)endConversationButton.click();
        assert (page.getBody().getTextContent().contains("Hello world!"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation", id="ib"), @SpecAssertion(section="conversation", id="iaa")})
    public void testBeanWithRequestScope() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("builtin.jsf"));
        assert (page.getBody().getTextContent().contains("Correct scope: true"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation", id="id")
    public void testBeanWithDefaultQualifier() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("builtin.jsf"));
        assert (page.getBody().getTextContent().contains("Correct qualifier: true"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation", id="ie")
    public void testBeanWithNameJavaxEnterpriseContextConversation() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("builtin.jsf"));
        assert (page.getBody().getTextContent().contains("Correct name: true"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation", id="l"), @SpecAssertion(section="conversation_context_ee", id="e")})
    public void testTransientConversationHasNullId() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("builtin.jsf"));
        assert (page.getBody().getTextContent().contains("Default conversation has null id: true"));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="ha"), @SpecAssertion(section="conversation", id="j")})
    public void testConversationIdMayBeSetByApplication() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        Assert.assertFalse((boolean)this.isLongRunning((Page)page));
        HtmlSubmitInput beginConversationButton = (HtmlSubmitInput)page.getElementById("form:beginConversationIdentifiedByCustomIdentifier");
        page = (HtmlPage)beginConversationButton.click();
        Assert.assertTrue((boolean)this.isLongRunning((Page)page));
        Assert.assertEquals((String)this.getCid((Page)page), (String)"humilis");
        Assert.assertTrue((boolean)page.getBody().getTextContent().contains("Cumulus humilis"));
        HtmlPage nextPage = (HtmlPage)client.getPage(this.getPath("cumulus.jsf?cid=humilis"));
        Assert.assertTrue((boolean)this.isLongRunning((Page)nextPage));
        Assert.assertEquals((String)this.getCid((Page)page), (String)"humilis");
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation_context_ee", id="hb"), @SpecAssertion(section="conversation", id="j")})
    public void testConversationIdMayBeSetByContainer() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationButton");
        page = (HtmlPage)beginConversationButton.click();
        assert (this.isLongRunning((Page)page).booleanValue());
        assert (this.getCid((Page)page) != null);
        assert (page.getBody().getTextContent().contains("Cumulus congestus"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="tb")
    public void testNonexistentConversationExceptionThrown() throws Exception {
        WebClient client = new WebClient();
        this.verifyNonexistentConversationExceptionThrown(client.getPage(this.getPath("cumulus.jsf?cid=foo")));
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="conversation", id="m"), @SpecAssertion(section="conversation", id="n")})
    public void testSetConversationTimeoutOverride() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationAndSetTimeout");
        page = (HtmlPage)beginConversationButton.click();
        assert (page.getBody().getTextContent().contains("Cumulonimbus"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation", id="m")
    public void testConversationHasDefaultTimeout() throws Exception {
        WebClient client = new WebClient();
        HtmlPage page = (HtmlPage)client.getPage(this.getPath("cumulus.jsf"));
        assert (!this.isLongRunning((Page)page).booleanValue());
        HtmlSubmitInput beginConversationButton = this.getFirstMatchingElement(page, HtmlSubmitInput.class, "beginConversationButton");
        page = (HtmlPage)beginConversationButton.click();
        assert (page.getBody().getTextContent().contains("Stratocumulus"));
    }

    @Test(groups={"integration"})
    @SpecAssertion(section="conversation_context_ee", id="oa")
    public void testSuppressedConversationPropagation() throws Exception {
        WebClient client = new WebClient();
        HtmlPage cloud = (HtmlPage)client.getPage(this.getPath("cloud.jsf"));
        Assert.assertEquals((String)this.getFirstMatchingElement(cloud, HtmlSpan.class, "cloudName").getTextContent(), (String)Cloud.NAME);
        HtmlPage page1 = (HtmlPage)this.getFirstMatchingElement(cloud, HtmlSubmitInput.class, "cumulus").click();
        Assert.assertEquals((String)this.getFirstMatchingElement(page1, HtmlSpan.class, "cloudName").getTextContent(), (String)"cumulus");
        String cid = this.getCid((Page)page1);
        HtmlPage page2 = (HtmlPage)client.getPage(this.getPath("cloud.jsf", cid));
        Assert.assertEquals((String)this.getFirstMatchingElement(page2, HtmlSpan.class, "cloudName").getTextContent(), (String)"cumulus");
        HtmlPage page3 = (HtmlPage)client.getPage(this.getPath("cloud.jsf", cid) + "&conversationPropagation=none");
        Assert.assertEquals((String)this.getFirstMatchingElement(page3, HtmlSpan.class, "cloudName").getTextContent(), (String)Cloud.NAME);
    }

    private void verifyNonexistentConversationExceptionThrown(Page page) {
        if (page instanceof TextPage) {
            TextPage textPage = (TextPage)page;
            Assert.assertTrue((boolean)textPage.getContent().contains("NonexistentConversationException thrown properly"));
            Assert.assertTrue((boolean)textPage.getContent().contains("Conversation.isTransient: true"));
            Assert.assertTrue((boolean)textPage.getContent().contains("Cloud: " + Cloud.NAME));
        } else {
            Assert.fail((String)("Unexpected response type: " + page.getClass().getName()));
        }
    }
}

