/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.discovery.implicit;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.discovery.implicit.NotDiscoveredBean;
import org.jboss.cdi.tck.tests.deployment.discovery.implicit.ProducedBean;
import org.jboss.cdi.tck.tests.deployment.discovery.implicit.TestExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeanDiscoveryMode;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class DefaultBeanDiscoveryModeTest
extends AbstractTest {
    @Inject
    BeanManager beanManager;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withBeansXml(((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).beanDiscoveryMode(BeanDiscoveryMode._ANNOTATED.toString()))).withTestClass(DefaultBeanDiscoveryModeTest.class)).withExtension(TestExtension.class)).withPackage(DefaultBeanDiscoveryModeTest.class.getPackage())).build();
    }

    @Test
    @SpecAssertion(id="a", section="default_bean_discovery")
    public void beanClassesNotDiscoveredTest() {
        Set beans = this.beanManager.getBeans(NotDiscoveredBean.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)0);
    }

    @Test
    @SpecAssertion(id="b", section="default_bean_discovery")
    public void producerMethodNotDiscovered() {
        Assert.assertEquals((int)TestExtension.processProducerMethodCounter.get(), (int)0);
    }

    @Test
    @SpecAssertion(id="c", section="default_bean_discovery")
    public void producerFieldNotDiscovered() {
        Assert.assertEquals((int)TestExtension.processProducerFieldCounter.get(), (int)0);
    }

    @Test
    @SpecAssertion(id="d", section="default_bean_discovery")
    public void disposerMethodNotDiscovered() {
        Assert.assertNull(TestExtension.disposerParam);
        Assert.assertFalse((boolean)NotDiscoveredBean.disposerCalled);
    }

    @Test
    @SpecAssertion(id="e", section="default_bean_discovery")
    public void observerMethodNotDiscovered() {
        Set observerMethods = this.beanManager.resolveObserverMethods((Object)new ProducedBean(), new Annotation[0]);
        Assert.assertEquals((int)observerMethods.size(), (int)0);
        Assert.assertEquals((int)TestExtension.processObserverCounter.get(), (int)0);
    }
}

