/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.deployment.exclude;

import java.lang.annotation.Annotation;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.TestSystemProperty;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.deployment.exclude.Alpha;
import org.jboss.cdi.tck.tests.deployment.exclude.Bravo;
import org.jboss.cdi.tck.tests.deployment.exclude.Charlie;
import org.jboss.cdi.tck.tests.deployment.exclude.Delta;
import org.jboss.cdi.tck.tests.deployment.exclude.Echo;
import org.jboss.cdi.tck.tests.deployment.exclude.Foxtrot;
import org.jboss.cdi.tck.tests.deployment.exclude.Golf;
import org.jboss.cdi.tck.tests.deployment.exclude.Stubble;
import org.jboss.cdi.tck.tests.deployment.exclude.VerifyingExtension;
import org.jboss.cdi.tck.tests.deployment.exclude.food.Meat;
import org.jboss.cdi.tck.tests.deployment.exclude.haircut.Chonmage;
import org.jboss.cdi.tck.tests.deployment.exclude.mustache.Mustache;
import org.jboss.cdi.tck.tests.deployment.exclude.mustache.beard.Beard;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeanDiscoveryMode;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.beans11.Exclude;
import org.jboss.shrinkwrap.descriptor.api.beans11.Scan;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class ExcludeFiltersTest
extends AbstractTest {
    @Inject
    VerifyingExtension extension;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ExcludeFiltersTest.class)).withPackage(Mustache.class.getPackage())).withPackage(Beard.class.getPackage())).withPackage(Chonmage.class.getPackage())).withPackage(Meat.class.getPackage())).withBeansXml((BeansDescriptor)((Scan)((Exclude)((Scan)((Exclude)((Scan)((Exclude)((Scan)((Exclude)((Scan)((Exclude)((Scan)((Scan)((Exclude)((Scan)((Exclude)((Scan)((Exclude)((Scan)((Scan)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).beanDiscoveryMode(BeanDiscoveryMode._ALL.toString()).createScan().createExclude().name(Chonmage.class.getPackage().getName() + ".*").up()).createExclude().name(Mustache.class.getPackage().getName() + ".**").up()).createExclude().name(Meat.class.getPackage().getName() + ".*").createIfClassAvailable().name("com.some.unreal.class.Name").up()).up()).createExclude().name(Meat.class.getPackage().getName() + ".*").createIfClassNotAvailable().name(ExcludeFiltersTest.class.getName()).up()).up()).createExclude().name(Alpha.class.getName()).createIfClassAvailable().name(Stubble.class.getName()).up()).up()).createExclude().name(Stubble.class.getName()).up()).createExclude().name(Foxtrot.class.getName()).createIfClassAvailable().name("com.some.unreal.class.Name").up()).up()).createExclude().name(Bravo.class.getName()).createIfClassNotAvailable().name("com.some.unreal.class.Name").up()).up()).createExclude().name(Echo.class.getName()).createIfClassNotAvailable().name(ExcludeFiltersTest.class.getName()).up()).up()).createExclude().name(Charlie.class.getName()).createIfSystemProperty().name(TestSystemProperty.EXCLUDE_DUMMY.getKey()).up()).up()).createExclude().name(Delta.class.getName()).createIfSystemProperty().name(TestSystemProperty.EXCLUDE_DUMMY.getKey()).value(TestSystemProperty.EXCLUDE_DUMMY.getValue()).up()).up()).up())).withExtension(VerifyingExtension.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="a"), @SpecAssertion(section="exclude_filters", id="f")})
    public void testTypeFcqnMatchesExcludeFilterName() {
        this.assertTypeIsExcluded(Stubble.class);
        this.assertTypeIsNotExcluded(Golf.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="a"), @SpecAssertion(section="exclude_filters", id="g"), @SpecAssertion(section="exclude_filters", id="h")})
    public void testTypePackageMatchesExcludeFilterName() {
        this.assertTypeIsExcluded(Mustache.class);
        this.assertTypeIsExcluded(Beard.class);
        this.assertTypeIsExcluded(Chonmage.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="b"), @SpecAssertion(section="exclude_filters", id="c")})
    public void testExcludeClassActivators() {
        this.assertTypeIsExcluded(Alpha.class);
        this.assertTypeIsNotExcluded(Foxtrot.class);
        this.assertTypeIsExcluded(Bravo.class);
        this.assertTypeIsNotExcluded(Echo.class);
        this.assertTypeIsNotExcluded(Meat.class);
    }

    @Test(groups={"integration", "systemProperties"})
    @SpecAssertions(value={@SpecAssertion(section="exclude_filters", id="d"), @SpecAssertion(section="exclude_filters", id="e")})
    public void testExcludeSystemPropertyActivator() {
        this.assertTypeIsExcluded(Charlie.class);
        this.assertTypeIsExcluded(Delta.class);
    }

    private void assertTypeIsExcluded(Class<?> type) {
        Assert.assertTrue((boolean)this.getBeans(type, new Annotation[0]).isEmpty());
        Assert.assertFalse((boolean)this.extension.getObservedAnnotatedTypes().contains(type));
    }

    private void assertTypeIsNotExcluded(Class<?> type) {
        Assert.assertFalse((boolean)this.getBeans(type, new Annotation[0]).isEmpty());
        Assert.assertTrue((boolean)this.extension.getObservedAnnotatedTypes().contains(type));
    }
}

