/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.async.basic;

import java.lang.annotation.Annotation;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.async.basic.American;
import org.jboss.cdi.tck.tests.event.observer.async.basic.Experiment;
import org.jboss.cdi.tck.tests.event.observer.async.basic.MixedObservers;
import org.jboss.cdi.tck.tests.event.observer.async.basic.ScientificExperiment;
import org.jboss.cdi.tck.util.ActionSequence;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class MixedObserversTest
extends AbstractTest {
    @Inject
    Event<ScientificExperiment> event;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MixedObserversTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_resolution", id="e")})
    public void testSyncEventIsDeliveredOnlyToSyncObservers() {
        ActionSequence.reset();
        this.event.fire((Object)new ScientificExperiment());
        ActionSequence.assertSequenceDataEquals(MixedObservers.OxfordUniversityObserver.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_resolution", id="f"), @SpecAssertion(section="event", id="eda")})
    public void testQualifiedAsyncEventIsDeliveredOnlyToAsyncObservers() throws InterruptedException {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        this.event.select(new Annotation[]{American.AmericanLiteral.INSTANCE}).fireAsync((Object)new ScientificExperiment()).thenAccept(queue::offer);
        Experiment experiment = (Experiment)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertEquals((int)experiment.getUniversities().size(), (int)3);
        Assert.assertTrue((boolean)experiment.getUniversities().contains(MixedObservers.YaleUniversityObserver.class));
        Assert.assertTrue((boolean)experiment.getUniversities().contains(MixedObservers.StandfordUniversityObserver.class));
        Assert.assertTrue((boolean)experiment.getUniversities().contains(MixedObservers.MassachusettsInstituteObserver.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="firing_events_asynchronously", id="a")})
    public void testAsyncObserversCalledInDifferentThread() throws InterruptedException {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        int threadId = (int)Thread.currentThread().getId();
        this.event.fireAsync((Object)new ScientificExperiment()).thenAccept(queue::offer);
        Experiment experiment2 = (Experiment)queue.poll(2L, TimeUnit.SECONDS);
        Assert.assertEquals((int)experiment2.getUniversities().size(), (int)2);
        Assert.assertTrue((boolean)experiment2.getUniversities().contains(MixedObservers.StandfordUniversityObserver.class));
        Assert.assertTrue((boolean)experiment2.getUniversities().contains(MixedObservers.MassachusettsInstituteObserver.class));
        Assert.assertNotEquals((Object)threadId, (Object)MixedObservers.MassachusettsInstituteObserver.threadId.get());
        Assert.assertEquals((int)MixedObservers.MassachusettsInstituteObserver.threadId.get(), (int)MixedObservers.StandfordUniversityObserver.threadId.get());
    }
}

