/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Specializes;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.interceptor.InterceptorBinding;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.RetentionLiteral;
import org.jboss.cdi.tck.literals.TargetLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.extensions.beanManager.AnimalStereotype;
import org.jboss.cdi.tck.tests.extensions.beanManager.DerivedBean;
import org.jboss.cdi.tck.tests.extensions.beanManager.Dog;
import org.jboss.cdi.tck.tests.extensions.beanManager.DogHouse;
import org.jboss.cdi.tck.tests.extensions.beanManager.DummyScoped;
import org.jboss.cdi.tck.tests.extensions.beanManager.Food;
import org.jboss.cdi.tck.tests.extensions.beanManager.InjectionPointDecorator;
import org.jboss.cdi.tck.tests.extensions.beanManager.Snake;
import org.jboss.cdi.tck.tests.extensions.beanManager.Soy;
import org.jboss.cdi.tck.tests.extensions.beanManager.Tame;
import org.jboss.cdi.tck.tests.extensions.beanManager.Terrier;
import org.jboss.cdi.tck.tests.extensions.beanManager.Transactional;
import org.jboss.cdi.tck.tests.extensions.beanManager.UnregisteredExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class BeanManagerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanManagerTest.class)).withClasses(RetentionLiteral.class, TargetLiteral.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateAlternatives().clazz(new String[]{Soy.class.getName()}).up())).withExtensions(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="a")
    public void testAmbiguousDependencyResolved() {
        Set beans = this.getCurrentManager().getBeans(Food.class, new Annotation[0]);
        Assert.assertEquals((int)beans.size(), (int)2);
        Bean bean = this.getCurrentManager().resolve(beans);
        Assert.assertNotNull((Object)bean);
        Assert.assertTrue((boolean)bean.isAlternative());
        Assert.assertTrue((boolean)this.typeSetMatches(bean.getTypes(), new Type[]{Food.class, Soy.class, Object.class}));
    }

    @Test(expectedExceptions={AmbiguousResolutionException.class})
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="b")
    public void testAmbiguousDependencyNotResolved() {
        HashSet beans = new HashSet();
        beans.addAll(this.getCurrentManager().getBeans(Dog.class, new Annotation[0]));
        beans.addAll(this.getCurrentManager().getBeans(Terrier.class, new Annotation[0]));
        this.getCurrentManager().resolve(beans);
    }

    @Test(expectedExceptions={InjectionException.class})
    @SpecAssertion(section="bm_validate_ip", id="a")
    public void testValidateThrowsException() {
        DogHouse dogHouse = this.getContextualReference(DogHouse.class, new Annotation[0]);
        InjectionPointDecorator injectionPoint = new InjectionPointDecorator(dogHouse.getDog().getInjectedMetadata());
        this.getCurrentManager().validate((InjectionPoint)injectionPoint);
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="aa")
    public void testDetermineQualifierType() {
        Assert.assertTrue((boolean)this.getCurrentManager().isQualifier(Any.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isQualifier(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isQualifier(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isQualifier(ApplicationScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isQualifier(Transactional.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ab")
    public void testDetermineScope() {
        Assert.assertTrue((boolean)this.getCurrentManager().isScope(ApplicationScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isScope(DummyScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isScope(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isScope(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isScope(Transactional.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ac")
    public void testDetermineStereotype() {
        Assert.assertTrue((boolean)this.getCurrentManager().isStereotype(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isStereotype(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isStereotype(ApplicationScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isStereotype(Transactional.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ad")
    public void testDetermineInterceptorBindingType() {
        Assert.assertTrue((boolean)this.getCurrentManager().isInterceptorBinding(Transactional.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isInterceptorBinding(Tame.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isInterceptorBinding(AnimalStereotype.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isInterceptorBinding(ApplicationScoped.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ae")
    public void testGetMetaAnnotationsForStereotype() {
        Set stereotypeAnnotations = this.getCurrentManager().getStereotypeDefinition(AnimalStereotype.class);
        Assert.assertEquals((int)stereotypeAnnotations.size(), (int)5);
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(new AnnotationLiteral<Stereotype>(){}));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(RequestScoped.Literal.INSTANCE));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(new AnnotationLiteral<Inherited>(){}));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(new RetentionLiteral(){

            @Override
            public RetentionPolicy value() {
                return RetentionPolicy.RUNTIME;
            }
        }));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(new TargetLiteral(){

            @Override
            public ElementType[] value() {
                ElementType[] value = new ElementType[]{ElementType.TYPE, ElementType.METHOD, ElementType.FIELD};
                return value;
            }
        }));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="af")
    public void testGetMetaAnnotationsForInterceptorBindingType() {
        Set metaAnnotations = this.getCurrentManager().getInterceptorBindingDefinition(Transactional.class);
        Assert.assertEquals((int)metaAnnotations.size(), (int)4);
        assert (this.annotationSetMatches((Set<? extends Annotation>)metaAnnotations, Target.class, Retention.class, Documented.class, InterceptorBinding.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ag")
    public void testDetermineScopeType() {
        Assert.assertTrue((boolean)this.getCurrentManager().isNormalScope(RequestScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isPassivatingScope(RequestScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isNormalScope(SessionScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isPassivatingScope(SessionScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isNormalScope(DummyScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isPassivatingScope(DummyScoped.class));
    }

    @Test
    @SpecAssertion(section="bm_obtain_elresolver", id="a")
    public void testGetELResolver() {
        Assert.assertNotNull((Object)this.getCurrentManager().getELResolver());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_annotatedtype", id="a")})
    public void testObtainingAnnotatedType() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DerivedBean.class);
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Specializes.class));
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Tame.class));
        Assert.assertEquals((int)1, (int)annotatedType.getFields().size());
        Assert.assertTrue((boolean)annotatedType.getMethods().isEmpty());
        Assert.assertEquals((int)3, (int)annotatedType.getTypeClosure().size());
    }

    @Test
    @SpecAssertion(section="bm_obtain_injectiontarget", id="aa")
    public void testObtainingInjectionTarget() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DerivedBean.class);
        Assert.assertNotNull((Object)this.getCurrentManager().createInjectionTarget(annotatedType));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_obtain_injectiontarget", id="ab")
    public void testObtainingInjectionTargetWithDefinitionError() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(Snake.class);
        this.getCurrentManager().createInjectionTarget(annotatedType);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_extension", id="a"), @SpecAssertion(section="bm_obtain_extension", id="b")})
    public void testGetExtension() {
        AfterBeanDiscoveryObserver extension = (AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)extension.getAfterBeanDiscoveryObserved());
        try {
            this.getCurrentManager().getExtension(UnregisteredExtension.class);
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        Assert.fail();
    }

    @Test
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="c")
    public void testResolveWithNull() {
        Assert.assertNull((Object)this.getCurrentManager().resolve(null));
    }

    @Test
    @SpecAssertion(section="bm_resolve_ambiguous_dep", id="d")
    public void testResolveWithEmptySet() {
        Assert.assertNull((Object)this.getCurrentManager().resolve(Collections.emptySet()));
        Assert.assertNull((Object)this.getCurrentManager().resolve(new HashSet()));
    }
}

