/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.beanManager.bean;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.BeanExtension;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.FireTruck;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Hungry;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Large;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Lion;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Office;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.SerializableOffice;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.SimpleInterceptor;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.Tiger;
import org.jboss.cdi.tck.tests.extensions.beanManager.bean.VehicleDecorator;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class SyntheticBeanTest
extends AbstractTest {
    @Inject
    @Large
    Office office;
    @Inject
    @Hungry
    Lion lion;
    @Inject
    @Hungry
    Tiger tiger;
    @Inject
    FireTruck truck;
    @Inject
    SerializableOffice serializableOffice;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SyntheticBeanTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{SimpleInterceptor.class.getName()}).up()).getOrCreateDecorators().clazz(new String[]{VehicleDecorator.class.getName()}).up())).withExtension(BeanExtension.class)).build();
    }

    @Test
    @SpecAssertion(section="bm_obtain_bean", id="a")
    public void testRegisteredBean() {
        Bean<Office> bean = this.getUniqueBean(Office.class, Large.Literal.INSTANCE);
        Assert.assertEquals((int)bean.getInjectionPoints().size(), (int)3);
        for (InjectionPoint ip : bean.getInjectionPoints()) {
            Assert.assertEquals(bean, (Object)ip.getBean());
        }
        this.testOffice(bean);
    }

    @Test
    @SpecAssertion(section="bm_obtain_bean", id="a")
    public void testSerializableBean() {
        Bean bean = this.getCurrentManager().resolve(this.getCurrentManager().getBeans(SerializableOffice.class, new Annotation[]{Any.Literal.INSTANCE}));
        Assert.assertTrue((boolean)(bean instanceof PassivationCapable));
        this.testOffice((Bean<Office>)bean);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="binding_interceptor_to_bean", id="c")})
    public void testSyntheticBeanIntercepted() {
        Assert.assertTrue((boolean)this.office.intercepted());
        Assert.assertTrue((boolean)this.serializableOffice.intercepted());
    }

    @Test
    @SpecAssertion(section="bm_obtain_bean", id="b")
    public void testSyntheticProducerField() {
        Assert.assertNotNull((Object)this.lion);
        this.lion.foo();
        Bean<Lion> bean = this.getUniqueBean(Lion.class, Hungry.Literal.INSTANCE);
        Assert.assertTrue((boolean)bean.getQualifiers().contains(Hungry.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="bm_obtain_bean", id="b")
    public void testSyntheticProducerMethod() {
        Assert.assertNotNull((Object)this.tiger);
        this.tiger.foo();
        Bean<Tiger> bean = this.getUniqueBean(Tiger.class, Hungry.Literal.INSTANCE);
        Assert.assertTrue((boolean)bean.getQualifiers().contains(Hungry.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="bm_obtain_bean", id="a")
    public void testSyntheticDecorator() {
        Assert.assertTrue((boolean)this.truck.decorated());
    }

    private void testOffice(Bean<Office> bean) {
        Office.reset();
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Office office = (Office)bean.create(ctx);
        Assert.assertNotNull((Object)office);
        Assert.assertNotNull((Object)office.getConstructorEmployee());
        Assert.assertNotNull((Object)office.getFieldEmployee());
        Assert.assertNotNull((Object)office.getInitializerEmployee());
        Assert.assertTrue((boolean)office.isPostConstructCalled());
        bean.destroy((Object)office, ctx);
        Assert.assertTrue((boolean)Office.isPreDestroyCalled());
    }
}

