/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.DisposesLiteral;
import org.jboss.cdi.tck.literals.ProducesLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Cat;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Cats;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Dog;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.DogDependenciesProducer;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Dogs;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.Feed;
import org.jboss.cdi.tck.tests.extensions.configurators.annotatedTypeConfigurator.ProcessAnnotatedTypeObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class AnnotatedTypeConfiguratorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(AnnotatedTypeConfiguratorTest.class)).withClasses(ProducesLiteral.class, DisposesLiteral.class)).withExtension(ProcessAnnotatedTypeObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotated_type_configurator", id="a"), @SpecAssertion(section="annotated_type_configurator", id="b"), @SpecAssertion(section="annotated_type_configurator", id="c"), @SpecAssertion(section="annotated_type_configurator", id="e"), @SpecAssertion(section="annotated_type_configurator", id="g"), @SpecAssertion(section="annotated_type_configurator", id="i"), @SpecAssertion(section="annotated_type_configurator", id="k"), @SpecAssertion(section="annotated_type_configurator", id="m"), @SpecAssertion(section="annotated_type_configurator", id="o")})
    public void addMethodsOfAnnotationTypecConfigurator() {
        Bean<Dog> dogBean = this.getUniqueBean(Dog.class, new Annotation[0]);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(dogBean);
        Dog dog = (Dog)dogBean.create(creationalContext);
        Assert.assertNotNull(dogBean);
        Assert.assertEquals((Object)dogBean.getScope(), RequestScoped.class);
        Assert.assertNotNull((Object)dog.getFeed());
        Assert.assertEquals((String)dog.getName(), (String)DogDependenciesProducer.dogName);
        List dogsInjectionPoints = dogBean.getInjectionPoints().stream().filter(injectionPoint -> injectionPoint.getQualifiers().contains(new Dogs.DogsLiteral())).collect(Collectors.toList());
        Assert.assertEquals((int)dogsInjectionPoints.size(), (int)2);
        Optional<InjectionPoint> feedIpOptional = dogsInjectionPoints.stream().filter(injectionPoint -> injectionPoint.getType().equals(Feed.class)).findFirst();
        Assert.assertTrue((boolean)feedIpOptional.isPresent());
        dogBean.destroy((Object)dog, creationalContext);
        Assert.assertTrue((boolean)DogDependenciesProducer.disposerCalled.get());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="annotated_type_configurator", id="d"), @SpecAssertion(section="annotated_type_configurator", id="f"), @SpecAssertion(section="annotated_type_configurator", id="h"), @SpecAssertion(section="annotated_type_configurator", id="j"), @SpecAssertion(section="annotated_type_configurator", id="l"), @SpecAssertion(section="annotated_type_configurator", id="n")})
    public void removeMethodsOfAnnotationTypeConfigurator() {
        Bean<Cat> catBean = this.getUniqueBean(Cat.class, new Annotation[0]);
        CreationalContext creationalContext = this.getCurrentManager().createCreationalContext(catBean);
        Cat cat = (Cat)catBean.create(creationalContext);
        Assert.assertNotNull(catBean);
        Assert.assertEquals((Object)catBean.getScope(), Dependent.class);
        Assert.assertNull((Object)cat.getFeed());
        Set<Bean<Feed>> catFeedBeans = this.getBeans(Feed.class, Cats.CatsLiteral.INSTANCE);
        Assert.assertEquals((int)catFeedBeans.size(), (int)0);
        this.getCurrentManager().fireEvent((Object)new Feed(), new Annotation[0]);
        Assert.assertFalse((boolean)cat.isFeedObserved());
    }
}

