/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.extensions.configurators.observerMethod;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.ObserverMethod;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Apple;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Delicious;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.FoodObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Orange;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Pear;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Pineapple;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.ProcessObserverMethodObserver;
import org.jboss.cdi.tck.tests.extensions.configurators.observerMethod.Ripe;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class ObserverMethodConfiguratorTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ObserverMethodConfiguratorTest.class)).withExtension(ProcessObserverMethodObserver.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="bb")})
    public void changeBeanClassAndObservedType() {
        Set appleEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Apple(), new Annotation[]{Any.Literal.INSTANCE});
        Assert.assertEquals((int)appleEventObservers.size(), (int)1);
        Assert.assertEquals((Object)((ObserverMethod)appleEventObservers.iterator().next()).getBeanClass(), FoodObserver.class);
        Assert.assertEquals((Object)((ObserverMethod)appleEventObservers.iterator().next()).getObservedType(), Apple.class);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="bg"), @SpecAssertion(section="observer_method_configurator", id="bd"), @SpecAssertion(section="observer_method_configurator", id="bi")})
    public void addQualifiersAndSetPriority() {
        Set pearEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Pear(), new Annotation[]{Any.Literal.INSTANCE, Ripe.RipeLiteral.INSTANCE, Delicious.DeliciousLiteral.INSTANCE});
        Assert.assertEquals((int)pearEventObservers.size(), (int)1);
        Assert.assertEquals((int)((ObserverMethod)pearEventObservers.iterator().next()).getPriority(), (int)2100);
        Assert.assertEquals((boolean)((ObserverMethod)pearEventObservers.iterator().next()).isAsync(), (boolean)true);
        Assert.assertEquals((Set)((ObserverMethod)pearEventObservers.iterator().next()).getObservedQualifiers(), Stream.of(Ripe.RipeLiteral.INSTANCE, Delicious.DeliciousLiteral.INSTANCE).collect(Collectors.toSet()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="be"), @SpecAssertion(section="observer_method_configurator", id="bf")})
    public void setReceptionAndTransactionPhase() {
        Set orangeEventObservers = this.getCurrentManager().resolveObserverMethods((Object)new Orange(), new Annotation[]{Any.Literal.INSTANCE, Delicious.DeliciousLiteral.INSTANCE});
        Assert.assertEquals((int)orangeEventObservers.size(), (int)1);
        Assert.assertEquals((Object)((ObserverMethod)orangeEventObservers.iterator().next()).getReception(), (Object)Reception.IF_EXISTS);
        Assert.assertEquals((Object)((ObserverMethod)orangeEventObservers.iterator().next()).getTransactionPhase(), (Object)TransactionPhase.AFTER_SUCCESS);
        Assert.assertEquals((Set)((ObserverMethod)orangeEventObservers.iterator().next()).getObservedQualifiers(), Collections.singleton(Delicious.DeliciousLiteral.INSTANCE));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_configurator", id="bc"), @SpecAssertion(section="observer_method_configurator", id="bh")})
    public void notifyAcceptingConsumerNotified() {
        this.getCurrentManager().fireEvent((Object)new Pineapple(), new Annotation[]{Delicious.DeliciousLiteral.INSTANCE});
        Assert.assertTrue((boolean)ProcessObserverMethodObserver.consumerNotified.get());
        Assert.assertEquals(ProcessObserverMethodObserver.pineAppleQualifiers, Arrays.asList(Any.Literal.INSTANCE, Delicious.DeliciousLiteral.INSTANCE));
    }
}

