/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.producer.field.definition;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.literal.NamedLiteral;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.TypeLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Animal;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.AsAnimal;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.BlackWidow;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.DeadlyAnimal;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.DeadlySpider;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Egg;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Foo;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.FunnelWeaverSpiderConsumer;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.FunnelWeaverSpiderProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.InfertileChicken;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.LameInfertileChicken;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.OtherSpiderProducer;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Pet;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Spider;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Static;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Tame;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.Tarantula;
import org.jboss.cdi.tck.tests.implementation.producer.field.definition.WolfSpider;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class ProducerFieldDefinitionTest
extends AbstractTest {
    private static final Annotation TAME_LITERAL = new AnnotationLiteral<Tame>(){};
    private static final Annotation PET_LITERAL = new AnnotationLiteral<Pet>(){};
    private static final Annotation FOO_LITERAL = new AnnotationLiteral<Foo>(){};
    private static final Annotation STATIC_LITERAL = new AnnotationLiteral<Static>(){};

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ProducerFieldDefinitionTest.class)).build();
    }

    @Test
    @SpecAssertion(section="producer_field", id="fa")
    public void testParameterizedReturnType() throws Exception {
        FunnelWeaverSpiderConsumer spiderConsumer = this.getContextualReference(FunnelWeaverSpiderConsumer.class, new Annotation[0]);
        assert (spiderConsumer != null);
        assert (spiderConsumer.getInjectedSpider() != null);
        assert (spiderConsumer.getInjectedSpider().equals(FunnelWeaverSpiderProducer.getSpider()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_field", id="j"), @SpecAssertion(section="producer_field", id="c"), @SpecAssertion(section="declaring_producer_field", id="a")})
    public void testBeanDeclaresMultipleProducerFields() {
        assert (this.getBeans(Tarantula.class, TAME_LITERAL).size() == 1);
        assert (this.getContextualReference(WolfSpider.class, PET_LITERAL).equals(OtherSpiderProducer.WOLF_SPIDER));
        assert (this.getBeans(BlackWidow.class, TAME_LITERAL).size() == 1);
        assert (this.getContextualReference(BlackWidow.class, TAME_LITERAL).equals(OtherSpiderProducer.BLACK_WIDOW));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtin_qualifiers", id="ab")})
    public void testDefaultBindingType() {
        Set<Bean<Tarantula>> tarantulaBeans = this.getBeans(Tarantula.class, new Annotation[0]);
        assert (tarantulaBeans.size() == 2);
        assert (tarantulaBeans.iterator().next().getQualifiers().contains(Default.Literal.INSTANCE));
    }

    @Test
    @SpecAssertion(section="producer_field_types", id="c")
    public void testApiTypeForClassReturn() {
        Set<Bean<Tarantula>> tarantulaBeans = this.getBeans(Tarantula.class, PET_LITERAL);
        assert (tarantulaBeans.size() == 1);
        Bean<Tarantula> tarantulaBean = tarantulaBeans.iterator().next();
        assert (tarantulaBean.getTypes().size() == 6);
        assert (tarantulaBean.getTypes().contains(Tarantula.class));
        assert (tarantulaBean.getTypes().contains(DeadlySpider.class));
        assert (tarantulaBean.getTypes().contains(Spider.class));
        assert (tarantulaBean.getTypes().contains(Animal.class));
        assert (tarantulaBean.getTypes().contains(DeadlyAnimal.class));
        assert (tarantulaBean.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="producer_field_types", id="a")
    public void testApiTypeForInterfaceReturn() {
        Set<Bean<Animal>> animalBeans = this.getBeans(Animal.class, new Annotation[]{new AnnotationLiteral<AsAnimal>(){}});
        assert (animalBeans.size() == 1);
        Bean<Animal> animalModel = animalBeans.iterator().next();
        assert (animalModel.getTypes().size() == 2);
        assert (animalModel.getTypes().contains(Animal.class));
        assert (animalModel.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertion(section="producer_field_types", id="ba")
    public void testApiTypeForPrimitiveReturn() {
        Set beans = this.getCurrentManager().getBeans("SpiderSize");
        assert (beans.size() == 1);
        Bean intModel = (Bean)beans.iterator().next();
        assert (intModel.getTypes().size() == 2);
        assert (intModel.getTypes().contains(Integer.TYPE));
        assert (intModel.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="producer_field_types", id="bb"), @SpecAssertion(section="legal_bean_types", id="i")})
    public void testApiTypeForArrayTypeReturn() {
        Set<Bean<Spider[]>> spidersBeans = this.getBeans(Spider[].class, new Annotation[0]);
        assert (spidersBeans.size() == 1);
        Bean<Spider[]> spidersModel = spidersBeans.iterator().next();
        assert (spidersModel.getTypes().size() == 2);
        assert (spidersModel.getTypes().contains(Spider[].class));
        assert (spidersModel.getTypes().contains(Object.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_field", id="f"), @SpecAssertion(section="declaring_bean_qualifiers", id="c")})
    public void testBindingType() {
        Set<Bean<Tarantula>> tarantulaBeans = this.getBeans(Tarantula.class, TAME_LITERAL);
        assert (tarantulaBeans.size() == 1);
        Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
        assert (tarantulaModel.getQualifiers().size() == 3);
        assert (tarantulaModel.getQualifiers().contains(TAME_LITERAL));
    }

    @Test
    @SpecAssertion(section="declaring_producer_field", id="b")
    public void testScopeType() {
        Set<Bean<Tarantula>> tarantulaBeans = this.getBeans(Tarantula.class, TAME_LITERAL, FOO_LITERAL);
        assert (!tarantulaBeans.isEmpty());
        Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
        assert (tarantulaModel.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_producer_field", id="c"), @SpecAssertion(section="declaring_bean_name", id="c")})
    public void testNamedField() {
        Set beans = this.getCurrentManager().getBeans("blackWidow");
        assert (beans.size() == 1);
        Bean blackWidowModel = (Bean)beans.iterator().next();
        assert (blackWidowModel.getName().equals("blackWidow"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="default_name", id="c"), @SpecAssertion(section="named_stereotype", id="aa"), @SpecAssertion(section="named_stereotype", id="ab"), @SpecAssertion(section="beans_with_no_name", id="a"), @SpecAssertion(section="producer_field_name", id="a")})
    public void testDefaultNamedByStereotype() {
        Bean<Tarantula> staticTarantulaBean = this.getUniqueBean(Tarantula.class, STATIC_LITERAL);
        Assert.assertEquals((String)staticTarantulaBean.getName(), (String)"produceTarantula");
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)staticTarantulaBean.getQualifiers(), new Annotation[]{Any.Literal.INSTANCE, STATIC_LITERAL}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="default_name", id="fc")})
    public void testDefaultNamed() {
        Bean<Tarantula> tarantulaBean = this.getUniqueBean(Tarantula.class, PET_LITERAL);
        Assert.assertEquals((String)tarantulaBean.getName(), (String)"producedPetTarantula");
        Assert.assertTrue((boolean)this.annotationSetMatches((Set<? extends Annotation>)tarantulaBean.getQualifiers(), new Annotation[]{Any.Literal.INSTANCE, PET_LITERAL, NamedLiteral.of((String)"producedPetTarantula")}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="declaring_stereotypes", id="c"), @SpecAssertion(section="declaring_producer_field", id="e")})
    public void testStereotype() {
        Set<Bean<Tarantula>> tarantulaBeans = this.getBeans(Tarantula.class, STATIC_LITERAL);
        assert (!tarantulaBeans.isEmpty());
        Bean<Tarantula> tarantulaModel = tarantulaBeans.iterator().next();
        assert (tarantulaModel.getScope().equals(RequestScoped.class));
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="ea")
    public void testNonStaticProducerFieldNotInherited() {
        assert (!(this.getContextualReference(Egg.class, FOO_LITERAL).getMother() instanceof InfertileChicken));
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="ec")
    public void testNonStaticProducerFieldNotIndirectlyInherited() {
        assert (!(this.getContextualReference(Egg.class, FOO_LITERAL).getMother() instanceof LameInfertileChicken));
    }

    @Test
    @SpecAssertion(section="producer_field", id="fb")
    public void testProducerFieldWithTypeVariable() {
        Assert.assertNotNull(this.getContextualReference(new TypeLiteral<List<Spider>>(){}, new Annotation[0]));
    }
}

