/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.resource.env;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.resource.env.Greeting;
import org.jboss.cdi.tck.tests.implementation.simple.resource.env.GreetingBean;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@Test(groups={"integration"})
@SpecVersion(spec="cdi", version="2.0-EDR1")
public class EnvInjectionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnvInjectionTest.class)).withBeansXml("beans.xml")).withWebXml("web.xml")).build();
    }

    @Test
    @SpecAssertion(section="declaring_resource", id="bb")
    public void testInjectionOfEnv() {
        Bean<GreetingBean> greetingBean = this.getBeans(GreetingBean.class, new Annotation[0]).iterator().next();
        CreationalContext greetingBeanCc = this.getCurrentManager().createCreationalContext(greetingBean);
        GreetingBean instance = (GreetingBean)greetingBean.create(greetingBeanCc);
        assert (instance.greet() != null);
        assert (instance.greet().equals("Hello there my friend"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_lifecycle", id="la"), @SpecAssertion(section="resource_lifecycle", id="ma"), @SpecAssertion(section="resource_lifecycle", id="o")})
    public void testProduceEnvProxy() {
        Bean<String> greetingEnvBean = this.getBeans(String.class, new Annotation[]{new AnnotationLiteral<Greeting>(){}}).iterator().next();
        CreationalContext greetingEnvCc = this.getCurrentManager().createCreationalContext(greetingEnvBean);
        String greeting = (String)greetingEnvBean.create(greetingEnvCc);
        assert (greeting != null);
        assert (greeting.equals("Hello there my friend"));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="resource_types", id="aa")})
    public void testResourceBeanTypes() {
        Bean<String> greeting = this.getBeans(String.class, new Annotation[]{new AnnotationLiteral<Greeting>(){}}).iterator().next();
        assert (greeting.getTypes().size() == 5);
        assert (this.rawTypeSetMatches(greeting.getTypes(), String.class, Object.class, Serializable.class, Comparable.class, CharSequence.class));
    }
}

