/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms;

import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.impl.ConfigurationFactory;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.shrinkwrap.descriptors.ejb.EjbJarDescriptorBuilder;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.MessageDrivenMissile;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.MissileInterceptor;
import org.jboss.cdi.tck.tests.interceptors.definition.enterprise.jms.SimpleMessageProducer;
import org.jboss.cdi.tck.util.Timer;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.shrinkwrap.descriptor.api.ejbjar31.EjbJarDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR1")
public class MessageDrivenBeanInterceptorInvocationTest
extends AbstractTest {
    @Inject
    SimpleMessageProducer producer;

    @Deployment
    public static WebArchive createTestArchive() {
        EjbJarDescriptor ejbJarDescriptor = new EjbJarDescriptorBuilder().messageDrivenBeans(EjbJarDescriptorBuilder.MessageDriven.newMessageDriven("TestQueue", MessageDrivenMissile.class.getName()).addActivationConfigProperty("acknowledgeMode", "Auto-acknowledge").addActivationConfigProperty("destinationType", "javax.jms.Queue").addActivationConfigProperty("destinationLookup", ConfigurationFactory.get().getTestJmsQueue())).build();
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(MessageDrivenBeanInterceptorInvocationTest.class)).withEjbJarXml(ejbJarDescriptor)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateInterceptors().clazz(new String[]{MissileInterceptor.class.getName()}).up())).build();
    }

    @Test(groups={"javaee-full", "jms"})
    @SpecAssertions(value={@SpecAssertion(section="biz_method_ee", id="la")})
    public void testMessageDrivenBeanMethodIntercepted() throws Exception {
        MissileInterceptor.reset();
        this.producer.sendQueueMessage();
        new Timer().setDelay(5L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

            @Override
            public boolean isSatisfied() {
                return MessageDrivenMissile.messageAccepted;
            }
        }).start();
        Assert.assertTrue((boolean)MessageDrivenMissile.messageAccepted);
        Assert.assertTrue((boolean)MissileInterceptor.methodIntercepted);
        Assert.assertTrue((boolean)MissileInterceptor.lifecycleCallbackIntercepted);
        Assert.assertTrue((boolean)MissileInterceptor.aroundConstructInterceptorCalled);
    }
}

