/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle;

import java.lang.annotation.Annotation;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.Bean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.AroundInvokeInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.Baz;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.MethodInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.PostConstructInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.PreDestroyInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.Warrior;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.WarriorAIInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.WarriorAttackAIInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.WarriorPCInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.WarriorPDInterceptor;
import org.jboss.cdi.tck.interceptors.tests.contract.interceptorLifeCycle.WeaponAIInterceptor;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="int", version="1.2")
public class InterceptorLifeCycleTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(InterceptorLifeCycleTest.class)).build();
    }

    @Test
    @SpecAssertion(section="2.2", id="e")
    public void testInterceptorMethodsCalledAfterDependencyInjection() {
        this.createCallAndDestroyBazInstance();
        Assert.assertTrue((boolean)AroundInvokeInterceptor.called);
        Assert.assertTrue((boolean)PostConstructInterceptor.called);
        Assert.assertTrue((boolean)PreDestroyInterceptor.called);
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertion(section="2.2", id="ba")
    public void testInterceptorInstanceCreatedWhenTargetInstanceCreated(Instance<Warrior> instance) {
        for (int i = 1; i < 3; ++i) {
            this.createWarriorInstanceAndAssertInterceptorsCount(instance, i);
        }
    }

    private void createWarriorInstanceAndAssertInterceptorsCount(Instance<Warrior> instance, int repetition) {
        Warrior warrior = (Warrior)instance.get();
        Assert.assertEquals((int)WarriorPCInterceptor.count, (int)repetition);
        Assert.assertEquals((int)WarriorPDInterceptor.count, (int)repetition);
        Assert.assertEquals((int)WarriorAIInterceptor.count, (int)repetition);
        Assert.assertEquals((int)MethodInterceptor.count, (int)repetition);
        Assert.assertEquals((int)WarriorAttackAIInterceptor.count, (int)repetition);
        Assert.assertEquals((int)WeaponAIInterceptor.count, (int)(2 * repetition));
        warrior.attack1();
        warrior.attack2();
        Assert.assertNotEquals((Object)warrior.getWeapon1().getWI(), (Object)warrior.getWeapon2().getWI());
        Assert.assertEquals((int)WarriorAIInterceptor.count, (int)repetition);
        Assert.assertEquals((int)MethodInterceptor.count, (int)repetition);
        Assert.assertEquals((int)WarriorAttackAIInterceptor.count, (int)repetition);
    }

    private void createCallAndDestroyBazInstance() {
        Class<Baz> clazz = Baz.class;
        Bean<Baz> bean = this.getUniqueBean(clazz, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        Baz instance = (Baz)this.getCurrentManager().getReference(bean, clazz, ctx);
        instance.doSomething();
        bean.destroy((Object)instance, ctx);
    }
}

