/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.decorators.definition;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import javax.decorator.Delegate;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.decorators.definition.AbstractFooDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.BankAccount;
import org.jboss.cdi.tck.tests.decorators.definition.Bar;
import org.jboss.cdi.tck.tests.decorators.definition.Baz;
import org.jboss.cdi.tck.tests.decorators.definition.BazDecorator1;
import org.jboss.cdi.tck.tests.decorators.definition.BazDecorator2;
import org.jboss.cdi.tck.tests.decorators.definition.Bazt;
import org.jboss.cdi.tck.tests.decorators.definition.Boo;
import org.jboss.cdi.tck.tests.decorators.definition.ChargeDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.Field;
import org.jboss.cdi.tck.tests.decorators.definition.Foo;
import org.jboss.cdi.tck.tests.decorators.definition.FooBar;
import org.jboss.cdi.tck.tests.decorators.definition.FooDecorator;
import org.jboss.cdi.tck.tests.decorators.definition.Logger;
import org.jboss.cdi.tck.tests.decorators.definition.Meta;
import org.jboss.cdi.tck.tests.decorators.definition.MockLogger;
import org.jboss.cdi.tck.tests.decorators.definition.NonMeta;
import org.jboss.cdi.tck.tests.decorators.definition.TimestampLogger;
import org.jboss.cdi.tck.util.Assert;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.beans11.BeansDescriptor;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class DecoratorDefinitionTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(DecoratorDefinitionTest.class)).withBeansXml((BeansDescriptor)((BeansDescriptor)Descriptors.create(BeansDescriptor.class)).getOrCreateDecorators().clazz(new String[]{BazDecorator1.class.getName(), BazDecorator2.class.getName(), FooDecorator.class.getName(), TimestampLogger.class.getName(), ChargeDecorator.class.getName()}).up())).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean", id="d"), @SpecAssertion(section="decorator_annotation", id="a"), @SpecAssertion(section="decorated_types", id="c"), @SpecAssertion(section="decorator_resolution", id="aa"), @SpecAssertion(section="decorator", id="a"), @SpecAssertion(section="bean_discovery_steps", id="g")})
    public void testDecoratorIsManagedBean() {
        List decorators = this.getCurrentManager().resolveDecorators(MockLogger.TYPES, new Annotation[0]);
        org.testng.Assert.assertEquals((int)decorators.size(), (int)1);
        boolean implementsInterface = false;
        for (Class<?> interfaze : ((Decorator)decorators.get(0)).getClass().getInterfaces()) {
            if (!Decorator.class.isAssignableFrom(interfaze)) continue;
            implementsInterface = true;
            break;
        }
        org.testng.Assert.assertTrue((boolean)implementsInterface);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean", id="b"), @SpecAssertion(section="decorator_bean", id="c"), @SpecAssertion(section="decorator", id="b"), @SpecAssertion(section="bm_decorator_resolution", id="a"), @SpecAssertion(section="bm_decorator_resolution", id="b")})
    public void testDecoratedTypes() {
        List decorators = this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[0]);
        org.testng.Assert.assertEquals((int)decorators.size(), (int)1);
        org.testng.Assert.assertEquals((int)((Decorator)decorators.get(0)).getDecoratedTypes().size(), (int)4);
        org.testng.Assert.assertTrue((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(Foo.class));
        org.testng.Assert.assertTrue((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(Bar.class));
        org.testng.Assert.assertTrue((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(Baz.class));
        org.testng.Assert.assertTrue((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(Boo.class));
        org.testng.Assert.assertFalse((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(Serializable.class));
        org.testng.Assert.assertFalse((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(FooDecorator.class));
        org.testng.Assert.assertFalse((boolean)((Decorator)decorators.get(0)).getDecoratedTypes().contains(AbstractFooDecorator.class));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="delegate_attribute", id="a"), @SpecAssertion(section="decorator", id="c")})
    public void testDelegateInjectionPoint() {
        List decorators = this.getCurrentManager().resolveDecorators(Logger.TYPES, new Annotation[0]);
        org.testng.Assert.assertEquals((int)decorators.size(), (int)1);
        Decorator decorator = (Decorator)decorators.get(0);
        org.testng.Assert.assertEquals((int)decorator.getInjectionPoints().size(), (int)1);
        org.testng.Assert.assertEquals((Object)((InjectionPoint)decorator.getInjectionPoints().iterator().next()).getType(), Logger.class);
        org.testng.Assert.assertTrue((boolean)((InjectionPoint)decorator.getInjectionPoints().iterator().next()).getAnnotated().isAnnotationPresent(Delegate.class));
        org.testng.Assert.assertEquals((Object)decorator.getDelegateType(), Logger.class);
        org.testng.Assert.assertEquals((int)decorator.getDelegateQualifiers().size(), (int)1);
        Assert.assertAnnotationSetMatches(decorator.getDelegateQualifiers(), Default.class);
    }

    @Test
    @SpecAssertion(section="decorated_types", id="b")
    public void testDecoratorDoesNotImplementDelegateType() {
        List decorators = this.getCurrentManager().resolveDecorators(Bazt.TYPES, new Annotation[0]);
        org.testng.Assert.assertEquals((int)decorators.size(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="enabled_decorators_bean_archive", id="b"), @SpecAssertion(section="decorator_resolution", id="aa"), @SpecAssertion(section="bm_decorator_resolution", id="a")})
    public void testDecoratorOrdering() {
        List decorators = this.getCurrentManager().resolveDecorators(Bazt.TYPES, new Annotation[0]);
        org.testng.Assert.assertEquals((int)decorators.size(), (int)2);
        org.testng.Assert.assertTrue((boolean)((Decorator)decorators.get(0)).getTypes().contains(BazDecorator1.class));
        org.testng.Assert.assertTrue((boolean)((Decorator)decorators.get(1)).getTypes().contains(BazDecorator2.class));
    }

    @Test
    @SpecAssertion(section="enabled_decorators_bean_archive", id="a")
    public void testNonEnabledDecoratorNotResolved() {
        List decorators = this.getCurrentManager().resolveDecorators(Field.TYPES, new Annotation[0]);
        org.testng.Assert.assertEquals((int)decorators.size(), (int)0);
    }

    @Test
    @SpecAssertion(section="decorator", id="d")
    public void testInstanceOfDecoratorForEachEnabled() {
        org.testng.Assert.assertFalse((boolean)this.getCurrentManager().resolveDecorators(MockLogger.TYPES, new Annotation[0]).isEmpty());
        org.testng.Assert.assertFalse((boolean)this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[0]).isEmpty());
        org.testng.Assert.assertFalse((boolean)this.getCurrentManager().resolveDecorators(Logger.TYPES, new Annotation[0]).isEmpty());
        org.testng.Assert.assertEquals((int)this.getCurrentManager().resolveDecorators(Bazt.TYPES, new Annotation[0]).size(), (int)2);
        org.testng.Assert.assertTrue((boolean)this.getCurrentManager().resolveDecorators(Field.TYPES, new Annotation[0]).isEmpty());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_decorator_resolution", id="c")
    public void testDuplicateBindingsOnResolveDecoratorsFails() {
        AnnotationLiteral<Meta> binding = new AnnotationLiteral<Meta>(){};
        this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[]{binding, binding});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_decorator_resolution", id="d")
    public void testNonBindingsOnResolveDecoratorsFails() {
        AnnotationLiteral<NonMeta> binding = new AnnotationLiteral<NonMeta>(){};
        this.getCurrentManager().resolveDecorators(FooBar.TYPES, new Annotation[]{binding});
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_decorator_resolution", id="e")
    public void testEmptyTypeSetOnResolveDecoratorsFails() {
        AnnotationLiteral<NonMeta> binding = new AnnotationLiteral<NonMeta>(){};
        this.getCurrentManager().resolveDecorators(new HashSet(), new Annotation[]{binding});
    }

    @Test(dataProvider="ARQUILLIAN_DATA_PROVIDER")
    @SpecAssertions(value={@SpecAssertion(section="decorator_bean", id="d"), @SpecAssertion(section="decorated_types", id="c"), @SpecAssertion(section="decorated_types", id="ca")})
    public void testAbstractDecoratorNotImplementingMethodOfDecoratedType(BankAccount account) {
        ChargeDecorator.reset();
        account.deposit(100);
        org.testng.Assert.assertEquals((int)ChargeDecorator.charged, (int)0);
        account.withdraw(50);
        org.testng.Assert.assertEquals((int)ChargeDecorator.charged, (int)5);
        org.testng.Assert.assertEquals((int)account.getBalance(), (int)45);
    }
}

