/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.enterprise.context.spi.Context;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.BullTerrier;
import org.jboss.cdi.tck.tests.event.Delivery;
import org.jboss.cdi.tck.tests.event.Egg;
import org.jboss.cdi.tck.tests.event.FarmShop;
import org.jboss.cdi.tck.tests.event.Farmer;
import org.jboss.cdi.tck.tests.event.IndirectStockWatcher;
import org.jboss.cdi.tck.tests.event.IntermediateStockWatcher;
import org.jboss.cdi.tck.tests.event.LazyFarmer;
import org.jboss.cdi.tck.tests.event.MultiBindingEvent;
import org.jboss.cdi.tck.tests.event.PrivateObserver;
import org.jboss.cdi.tck.tests.event.RoleLiteral;
import org.jboss.cdi.tck.tests.event.Shop;
import org.jboss.cdi.tck.tests.event.StaticObserver;
import org.jboss.cdi.tck.tests.event.StockPrice;
import org.jboss.cdi.tck.tests.event.StockWatcher;
import org.jboss.cdi.tck.tests.event.TameAnnotationLiteral;
import org.jboss.cdi.tck.tests.event.TerrierObserver;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class EventTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EventTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observes", id="i"), @SpecAssertion(section="observers_method_invocation", id="c"), @SpecAssertion(section="method_constructor_parameter_qualifiers", id="ca"), @SpecAssertion(section="injection_point_default_qualifier", id="a")})
    public void testObserverMethodParameterInjectionPoints() {
        TerrierObserver.reset();
        this.getCurrentManager().fireEvent((Object)new BullTerrier(), new Annotation[0]);
        Assert.assertTrue((boolean)TerrierObserver.eventObserved);
        Assert.assertTrue((boolean)TerrierObserver.parametersInjected);
    }

    @Test(groups={"integration"})
    @SpecAssertions(value={@SpecAssertion(section="observer_methods", id="c"), @SpecAssertion(section="observers_method_invocation", id="a")})
    public void testStaticObserverMethodInvoked() {
        Context requestContext = this.getCurrentConfiguration().getContexts().getRequestContext();
        try {
            this.getCurrentConfiguration().getContexts().setInactive(requestContext);
            StaticObserver.reset();
            this.getCurrentManager().fireEvent((Object)new Delivery(), new Annotation[0]);
            Assert.assertTrue((boolean)StaticObserver.isDeliveryReceived());
        }
        finally {
            this.getCurrentConfiguration().getContexts().setActive(requestContext);
        }
    }

    @Test
    @SpecAssertion(section="observes", id="a")
    public void testPrivateObserverMethodInvoked() {
        PrivateObserver.reset();
        this.getCurrentManager().fireEvent((Object)new Delivery(), new Annotation[0]);
        Assert.assertTrue((boolean)PrivateObserver.isObserved);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="specialization", id="cc"), @SpecAssertion(section="observers_method_invocation", id="baa")})
    public void testObserverCalledOnSpecializedBeanOnly() {
        Shop.observers.clear();
        this.getCurrentManager().fireEvent((Object)new Delivery(), new Annotation[0]);
        Assert.assertEquals((int)Shop.observers.size(), (int)1);
        Assert.assertEquals((String)Shop.observers.iterator().next(), (String)FarmShop.class.getName());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_observer_method_resolution", id="c")
    public <T> void testEventObjectContainsTypeVariablesWhenResolvingFails() {
        this.eventObjectContainsTypeVariables(new ArrayList());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="multiple_event_qualifiers", id="a"), @SpecAssertion(section="multiple_event_qualifiers", id="b")})
    public void testObserverMethodNotifiedWhenQualifiersMatch() {
        BullTerrier.reset();
        this.getCurrentManager().fireEvent((Object)new MultiBindingEvent(), new Annotation[]{new RoleLiteral("Admin"), new TameAnnotationLiteral()});
        Assert.assertTrue((boolean)BullTerrier.isMultiBindingEventObserved());
        Assert.assertTrue((boolean)BullTerrier.isSingleBindingEventObserved());
    }

    @Test
    @SpecAssertion(section="member_level_inheritance", id="dc")
    public void testNonStaticObserverMethodInherited() {
        Egg egg = new Egg();
        this.getCurrentManager().fireEvent((Object)egg, new Annotation[0]);
        Assert.assertTrue((boolean)this.typeSetMatches(egg.getClassesVisited(), new Type[]{Farmer.class, LazyFarmer.class}));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="member_level_inheritance", id="di")})
    public void testNonStaticObserverMethodIndirectlyInherited() {
        StockPrice price = new StockPrice();
        this.getCurrentManager().fireEvent((Object)price, new Annotation[0]);
        Assert.assertTrue((boolean)this.typeSetMatches(price.getClassesVisited(), new Type[]{StockWatcher.class, IntermediateStockWatcher.class, IndirectStockWatcher.class}));
    }

    private <E> void eventObjectContainsTypeVariables(ArrayList<E> eventToFire) {
        this.getCurrentManager().resolveObserverMethods(eventToFire, new Annotation[0]);
    }
}

