/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.context.async.enterprise;

import java.util.concurrent.ExecutionException;
import javax.ejb.EJBAccessException;
import javax.inject.Inject;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.context.async.enterprise.Student;
import org.jboss.cdi.tck.tests.event.observer.context.async.enterprise.Teacher;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"integration", "javaee-full"})
@SpecVersion(spec="cdi", version="2.0-EDR2")
public class EnterpriseSecurityContextPropagationInAsyncObserverTest
extends AbstractTest {
    @Inject
    Student student;
    @Inject
    Teacher teacher;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(EnterpriseSecurityContextPropagationInAsyncObserverTest.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_invocation_context_ee", id="a"), @SpecAssertion(section="observer_method_invocation_context_ee", id="b")})
    public void testSecurityContextPropagation() throws InterruptedException, ExecutionException {
        Assert.assertEquals((String)Student.STUDENT_MESSAGE, (String)this.student.print().getContent());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observer_method_invocation_context_ee", id="a"), @SpecAssertion(section="observer_method_invocation_context_ee", id="b")})
    public void testSecurityContextNotPropagated() throws InterruptedException {
        Throwable expectedException = this.teacher.print();
        Assert.assertNotNull((Object)expectedException);
        Assert.assertTrue((boolean)(expectedException.getCause() instanceof EJBAccessException));
    }
}

