/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.priority.contextLifecycleEvent;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Destroyed;
import javax.enterprise.context.Initialized;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Observes;
import javax.servlet.ServletRequest;
import org.jboss.weld.experimental.Priority;

@ApplicationScoped
public class RequestContextLifecycleObserver {
    private List<String> initializedEvents = new CopyOnWriteArrayList<String>();
    private List<String> destroyedEvents = new CopyOnWriteArrayList<String>();

    public void firstInit(@Observes @Initialized(value=RequestScoped.class) @Priority(value=1900) ServletRequest servletRequest) {
        this.initializedEvents.add("A");
    }

    public void secondInit(@Observes @Initialized(value=RequestScoped.class) ServletRequest servletRequest) {
        this.initializedEvents.add("B");
    }

    public void thirdInit(@Observes @Initialized(value=RequestScoped.class) @Priority(value=2501) ServletRequest servletRequest) {
        this.initializedEvents.add("C");
    }

    public void firstDestroy(@Observes @Destroyed(value=RequestScoped.class) @Priority(value=2000) ServletRequest servletRequest) {
        this.destroyedEvents.add("A");
    }

    public void secondDestroy(@Observes @Destroyed(value=RequestScoped.class) ServletRequest servletRequest) {
        this.destroyedEvents.add("B");
    }

    public void thirdDestroy(@Observes @Destroyed(value=RequestScoped.class) @Priority(value=2501) ServletRequest servletRequest) {
        this.destroyedEvents.add("C");
    }

    public List<String> getDestroyedEvents() {
        return this.destroyedEvents;
    }

    public List<String> getInitializedEvents() {
        return this.initializedEvents;
    }
}

