/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.event.observer.resolve;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.AnnotationLiteral;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.event.observer.resolve.AirConditioner;
import org.jboss.cdi.tck.tests.event.observer.resolve.BatteryEvent;
import org.jboss.cdi.tck.tests.event.observer.resolve.DiskSpaceEvent;
import org.jboss.cdi.tck.tests.event.observer.resolve.Ghost;
import org.jboss.cdi.tck.tests.event.observer.resolve.MultiBindingEvent;
import org.jboss.cdi.tck.tests.event.observer.resolve.RoleBinding;
import org.jboss.cdi.tck.tests.event.observer.resolve.Secret;
import org.jboss.cdi.tck.tests.event.observer.resolve.SimpleEventType;
import org.jboss.cdi.tck.tests.event.observer.resolve.TameAnnotationLiteral;
import org.jboss.cdi.tck.tests.event.observer.resolve.Temperature;
import org.jboss.cdi.tck.tests.event.observer.resolve.User;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0-EDR2")
public class ResolveEventObserversTest
extends AbstractTest {
    private static final String BEAN_MANAGER_RESOLVE_OBSERVERS_METHOD_NAME = "resolveObserverMethods";

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(ResolveEventObserversTest.class)).build();
    }

    @Test
    @SpecAssertion(section="observer_methods", id="e")
    public void testMultipleObserverMethodsForSameEventPermissible() {
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new DiskSpaceEvent(), new Annotation[0]).size(), (int)2);
    }

    @Test
    @SpecAssertion(section="observer_methods", id="f")
    public void testMultipleObserverMethodsOnBeanPermissible() {
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new BatteryEvent(), new Annotation[0]).size(), (int)1);
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new DiskSpaceEvent(), new Annotation[0]).size(), (int)2);
    }

    @Test
    @SpecAssertion(section="observes", id="a")
    public void testMethodWithParameterAnnotatedWithObservesRegistersObserverMethod() throws SecurityException, NoSuchMethodException {
        Set temperatureObservers = this.getCurrentManager().resolveObserverMethods((Object)new Temperature(0.0), new Annotation[0]);
        Assert.assertEquals((int)temperatureObservers.size(), (int)1);
        ObserverMethod temperatureObserver = (ObserverMethod)temperatureObservers.iterator().next();
        Assert.assertEquals((Object)temperatureObserver.getBeanClass(), AirConditioner.class);
        Assert.assertEquals((Object)temperatureObserver.getObservedType(), Temperature.class);
        Method method = AirConditioner.class.getMethod("temperatureChanged", Temperature.class);
        Assert.assertNotNull((Object)method);
        Assert.assertEquals((int)method.getParameterTypes().length, (int)1);
        Assert.assertEquals(method.getParameterTypes()[0], Temperature.class);
        Assert.assertEquals(method.getParameterAnnotations()[0][0].annotationType(), Observes.class);
    }

    @Test
    @SpecAssertion(section="observer_method_event_parameter", id="b")
    public void testObserverMethodWithoutBindingTypesObservesEventsWithoutBindingTypes() {
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new SimpleEventType(), new Annotation[0]).size(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observes", id="c"), @SpecAssertion(section="event_qualifier_types_with_members", id="a"), @SpecAssertion(section="multiple_event_qualifiers", id="a")})
    public void testObserverMethodMayHaveMultipleBindingTypes() {
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new MultiBindingEvent(), new Annotation[]{new RoleBinding("Admin"), new TameAnnotationLiteral()}).size(), (int)2);
    }

    @Test
    @SpecAssertion(section="observer_notification", id="aa")
    public void testObserverMethodRegistration() {
        Assert.assertEquals((int)this.getCurrentManager().resolveObserverMethods((Object)new SimpleEventType(), new Annotation[0]).size(), (int)2);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_observer_method_resolution", id="a"), @SpecAssertion(section="bm_observer_method_resolution", id="b")})
    public void testBeanManagerResolveObserversSignature() throws Exception {
        Assert.assertNotNull((Object)this.getCurrentManager().getClass().getDeclaredMethod(BEAN_MANAGER_RESOLVE_OBSERVERS_METHOD_NAME, Object.class, Annotation[].class));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_observer_method_resolution", id="e")
    public void testBeanManagerResolveObserversWithIllegalQualifier() {
        this.getCurrentManager().resolveObserverMethods((Object)new SimpleEventType(), new Annotation[]{new AnnotationLiteral<Override>(){}});
    }

    @Test
    @SpecAssertion(section="bean_discovery_steps", id="o")
    public void testObserverMethodAutomaticallyRegistered() {
        Assert.assertFalse((boolean)this.getCurrentManager().resolveObserverMethods((Object)new String(), new Annotation[]{new AnnotationLiteral<Secret>(){}}).isEmpty());
    }

    @Test
    @SpecAssertion(section="bean_discovery_steps", id="o")
    public void testObserverMethodNotAutomaticallyRegisteredForDisabledBeans() {
        Set ghostObservers = this.getCurrentManager().resolveObserverMethods((Object)new Ghost(), new Annotation[0]);
        Assert.assertEquals((int)ghostObservers.size(), (int)0);
        Set stringObservers = this.getCurrentManager().resolveObserverMethods((Object)new String(), new Annotation[]{new AnnotationLiteral<Secret>(){}});
        Assert.assertEquals((int)stringObservers.size(), (int)1);
        for (ObserverMethod observer : stringObservers) {
            observer.notify((Object)"fail if disabled observer invoked");
        }
    }

    @Test
    @SpecAssertion(section="observes", id="ab")
    public void testSyncObserver() {
        Set diskSpaceObservers = this.getCurrentManager().resolveObserverMethods((Object)new DiskSpaceEvent(), new Annotation[0]);
        Assert.assertTrue((boolean)diskSpaceObservers.stream().allMatch(method -> !method.isAsync()));
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="observes", id="ac"), @SpecAssertion(section="observer_method", id="g")})
    public void testAsyncObserver() {
        Set userObservers = this.getCurrentManager().resolveObserverMethods((Object)new User(), new Annotation[0]);
        Assert.assertEquals((int)userObservers.size(), (int)1);
        Assert.assertTrue((boolean)((ObserverMethod)userObservers.iterator().next()).isAsync());
    }
}

